/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

@MutinyGen(value=io.vertx.sqlclient.Tuple.class)
public class Tuple {
    public static final TypeArg<Tuple> __TYPE_ARG = new TypeArg(obj -> new Tuple((io.vertx.sqlclient.Tuple)obj), Tuple::getDelegate);
    private final io.vertx.sqlclient.Tuple delegate;
    public static final Object JSON_NULL = io.vertx.sqlclient.Tuple.JSON_NULL;

    public Tuple(io.vertx.sqlclient.Tuple delegate) {
        this.delegate = delegate;
    }

    public Tuple(Object delegate) {
        this.delegate = (io.vertx.sqlclient.Tuple)delegate;
    }

    Tuple() {
        this.delegate = null;
    }

    public io.vertx.sqlclient.Tuple getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple that = (Tuple)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static Tuple tuple() {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.tuple());
        return ret;
    }

    public static <T> Tuple from(List<T> list) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.from(list));
        return ret;
    }

    public static <T> Tuple wrap(List<T> list) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.wrap(list));
        return ret;
    }

    public static Tuple of(Object elt1) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.of((Object)elt1));
        return ret;
    }

    public static Tuple of(Object elt1, Object elt2) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.of((Object)elt1, (Object)elt2));
        return ret;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.of((Object)elt1, (Object)elt2, (Object)elt3));
        return ret;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.of((Object)elt1, (Object)elt2, (Object)elt3, (Object)elt4));
        return ret;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.of((Object)elt1, (Object)elt2, (Object)elt3, (Object)elt4, (Object)elt5));
        return ret;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5, Object elt6) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.of((Object)elt1, (Object)elt2, (Object)elt3, (Object)elt4, (Object)elt5, (Object)elt6));
        return ret;
    }

    public static Tuple tuple(List<Object> elements) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.tuple(elements));
        return ret;
    }

    public Object getValue(int pos) {
        Object ret = this.delegate.getValue(pos);
        return ret;
    }

    public Boolean getBoolean(int pos) {
        Boolean ret = this.delegate.getBoolean(pos);
        return ret;
    }

    public Short getShort(int pos) {
        Short ret = this.delegate.getShort(pos);
        return ret;
    }

    public Integer getInteger(int pos) {
        Integer ret = this.delegate.getInteger(pos);
        return ret;
    }

    public Long getLong(int pos) {
        Long ret = this.delegate.getLong(pos);
        return ret;
    }

    public Float getFloat(int pos) {
        Float ret = this.delegate.getFloat(pos);
        return ret;
    }

    public Double getDouble(int pos) {
        Double ret = this.delegate.getDouble(pos);
        return ret;
    }

    public String getString(int pos) {
        String ret = this.delegate.getString(pos);
        return ret;
    }

    public JsonObject getJsonObject(int pos) {
        JsonObject ret = this.delegate.getJsonObject(pos);
        return ret;
    }

    public JsonArray getJsonArray(int pos) {
        JsonArray ret = this.delegate.getJsonArray(pos);
        return ret;
    }

    public Object getJson(int pos) {
        Object ret = this.delegate.getJson(pos);
        return ret;
    }

    public Buffer getBuffer(int pos) {
        Buffer ret = Buffer.newInstance((io.vertx.core.buffer.Buffer)this.delegate.getBuffer(pos));
        return ret;
    }

    @Fluent
    public Tuple addValue(Object value) {
        this.delegate.addValue(value);
        return this;
    }

    @Fluent
    public Tuple addBoolean(Boolean value) {
        this.delegate.addBoolean(value);
        return this;
    }

    @Fluent
    public Tuple addShort(Short value) {
        this.delegate.addShort(value);
        return this;
    }

    @Fluent
    public Tuple addInteger(Integer value) {
        this.delegate.addInteger(value);
        return this;
    }

    @Fluent
    public Tuple addLong(Long value) {
        this.delegate.addLong(value);
        return this;
    }

    @Fluent
    public Tuple addFloat(Float value) {
        this.delegate.addFloat(value);
        return this;
    }

    @Fluent
    public Tuple addDouble(Double value) {
        this.delegate.addDouble(value);
        return this;
    }

    @Fluent
    public Tuple addString(String value) {
        this.delegate.addString(value);
        return this;
    }

    @Fluent
    public Tuple addJsonObject(JsonObject value) {
        this.delegate.addJsonObject(value);
        return this;
    }

    @Fluent
    public Tuple addJsonArray(JsonArray value) {
        this.delegate.addJsonArray(value);
        return this;
    }

    @Fluent
    public Tuple addBuffer(Buffer value) {
        this.delegate.addBuffer(value.getDelegate());
        return this;
    }

    public <T> T get(Class<T> type, int position) {
        Object ret = TypeArg.of(type).wrap(this.delegate.get(MutinyHelper.unwrap(type), position));
        return (T)ret;
    }

    public int size() {
        int ret = this.delegate.size();
        return ret;
    }

    public void clear() {
        this.delegate.clear();
    }

    public String deepToString() {
        String ret = this.delegate.deepToString();
        return ret;
    }

    public static Tuple from(Object[] array) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.from((Object[])array));
        return ret;
    }

    public static Tuple wrap(Object[] array) {
        Tuple ret = Tuple.newInstance(io.vertx.sqlclient.Tuple.wrap((Object[])array));
        return ret;
    }

    public Numeric getNumeric(int pos) {
        Numeric ret = this.delegate.getNumeric(pos);
        return ret;
    }

    public Temporal getTemporal(int pos) {
        Temporal ret = this.delegate.getTemporal(pos);
        return ret;
    }

    public LocalDate getLocalDate(int pos) {
        LocalDate ret = this.delegate.getLocalDate(pos);
        return ret;
    }

    public LocalTime getLocalTime(int pos) {
        LocalTime ret = this.delegate.getLocalTime(pos);
        return ret;
    }

    public LocalDateTime getLocalDateTime(int pos) {
        LocalDateTime ret = this.delegate.getLocalDateTime(pos);
        return ret;
    }

    public OffsetTime getOffsetTime(int pos) {
        OffsetTime ret = this.delegate.getOffsetTime(pos);
        return ret;
    }

    public OffsetDateTime getOffsetDateTime(int pos) {
        OffsetDateTime ret = this.delegate.getOffsetDateTime(pos);
        return ret;
    }

    public UUID getUUID(int pos) {
        UUID ret = this.delegate.getUUID(pos);
        return ret;
    }

    public BigDecimal getBigDecimal(int pos) {
        BigDecimal ret = this.delegate.getBigDecimal(pos);
        return ret;
    }

    public Boolean[] getArrayOfBooleans(int pos) {
        Boolean[] ret = this.delegate.getArrayOfBooleans(pos);
        return ret;
    }

    public Short[] getArrayOfShorts(int pos) {
        Short[] ret = this.delegate.getArrayOfShorts(pos);
        return ret;
    }

    public Integer[] getArrayOfIntegers(int pos) {
        Integer[] ret = this.delegate.getArrayOfIntegers(pos);
        return ret;
    }

    public Long[] getArrayOfLongs(int pos) {
        Long[] ret = this.delegate.getArrayOfLongs(pos);
        return ret;
    }

    public Float[] getArrayOfFloats(int pos) {
        Float[] ret = this.delegate.getArrayOfFloats(pos);
        return ret;
    }

    public Double[] getArrayOfDoubles(int pos) {
        Double[] ret = this.delegate.getArrayOfDoubles(pos);
        return ret;
    }

    public Numeric[] getArrayOfNumerics(int pos) {
        Numeric[] ret = this.delegate.getArrayOfNumerics(pos);
        return ret;
    }

    public String[] getArrayOfStrings(int pos) {
        String[] ret = this.delegate.getArrayOfStrings(pos);
        return ret;
    }

    public JsonObject[] getArrayOfJsonObjects(int pos) {
        JsonObject[] ret = this.delegate.getArrayOfJsonObjects(pos);
        return ret;
    }

    public JsonArray[] getArrayOfJsonArrays(int pos) {
        JsonArray[] ret = this.delegate.getArrayOfJsonArrays(pos);
        return ret;
    }

    public Object[] getArrayOfJsons(int pos) {
        Object[] ret = this.delegate.getArrayOfJsons(pos);
        return ret;
    }

    public Temporal[] getArrayOfTemporals(int pos) {
        Temporal[] ret = this.delegate.getArrayOfTemporals(pos);
        return ret;
    }

    public LocalDate[] getArrayOfLocalDates(int pos) {
        LocalDate[] ret = this.delegate.getArrayOfLocalDates(pos);
        return ret;
    }

    public LocalTime[] getArrayOfLocalTimes(int pos) {
        LocalTime[] ret = this.delegate.getArrayOfLocalTimes(pos);
        return ret;
    }

    public LocalDateTime[] getArrayOfLocalDateTimes(int pos) {
        LocalDateTime[] ret = this.delegate.getArrayOfLocalDateTimes(pos);
        return ret;
    }

    public OffsetTime[] getArrayOfOffsetTimes(int pos) {
        OffsetTime[] ret = this.delegate.getArrayOfOffsetTimes(pos);
        return ret;
    }

    public OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) {
        OffsetDateTime[] ret = this.delegate.getArrayOfOffsetDateTimes(pos);
        return ret;
    }

    public UUID[] getArrayOfUUIDs(int pos) {
        UUID[] ret = this.delegate.getArrayOfUUIDs(pos);
        return ret;
    }

    public BigDecimal[] getArrayOfBigDecimals(int pos) {
        BigDecimal[] ret = this.delegate.getArrayOfBigDecimals(pos);
        return ret;
    }

    public Tuple addTemporal(Temporal value) {
        Tuple ret = Tuple.newInstance(this.delegate.addTemporal(value));
        return ret;
    }

    public Tuple addLocalDate(LocalDate value) {
        Tuple ret = Tuple.newInstance(this.delegate.addLocalDate(value));
        return ret;
    }

    public Tuple addLocalTime(LocalTime value) {
        Tuple ret = Tuple.newInstance(this.delegate.addLocalTime(value));
        return ret;
    }

    public Tuple addLocalDateTime(LocalDateTime value) {
        Tuple ret = Tuple.newInstance(this.delegate.addLocalDateTime(value));
        return ret;
    }

    public Tuple addOffsetTime(OffsetTime value) {
        Tuple ret = Tuple.newInstance(this.delegate.addOffsetTime(value));
        return ret;
    }

    public Tuple addOffsetDateTime(OffsetDateTime value) {
        Tuple ret = Tuple.newInstance(this.delegate.addOffsetDateTime(value));
        return ret;
    }

    public Tuple addUUID(UUID value) {
        Tuple ret = Tuple.newInstance(this.delegate.addUUID(value));
        return ret;
    }

    public Tuple addBigDecimal(BigDecimal value) {
        Tuple ret = Tuple.newInstance(this.delegate.addBigDecimal(value));
        return ret;
    }

    public Tuple addArrayOfBoolean(Boolean[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfBoolean(value));
        return ret;
    }

    public Tuple addArrayOfShort(Short[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfShort(value));
        return ret;
    }

    public Tuple addArrayOfInteger(Integer[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfInteger(value));
        return ret;
    }

    public Tuple addArrayOfLong(Long[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfLong(value));
        return ret;
    }

    public Tuple addArrayOfFloat(Float[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfFloat(value));
        return ret;
    }

    public Tuple addArrayOfDouble(Double[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfDouble(value));
        return ret;
    }

    public Tuple addArrayOfString(String[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfString(value));
        return ret;
    }

    public Tuple addArrayOfJsonObject(JsonObject[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfJsonObject(value));
        return ret;
    }

    public Tuple addArrayOfJsonArray(JsonArray[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfJsonArray(value));
        return ret;
    }

    public Tuple addArrayOfTemporal(Temporal[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfTemporal(value));
        return ret;
    }

    public Tuple addArrayOfLocalDate(LocalDate[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfLocalDate(value));
        return ret;
    }

    public Tuple addArrayOfLocalTime(LocalTime[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfLocalTime(value));
        return ret;
    }

    public Tuple addArrayOfLocalDateTime(LocalDateTime[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfLocalDateTime(value));
        return ret;
    }

    public Tuple addArrayOfOffsetTime(OffsetTime[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfOffsetTime(value));
        return ret;
    }

    public Tuple addArrayOfOffsetDateTime(OffsetDateTime[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfOffsetDateTime(value));
        return ret;
    }

    public Tuple addArrayOfUUID(UUID[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfUUID(value));
        return ret;
    }

    public Tuple addArrayOfBigDecimal(BigDecimal[] value) {
        Tuple ret = Tuple.newInstance(this.delegate.addArrayOfBigDecimal(value));
        return ret;
    }

    public static Tuple newInstance(io.vertx.sqlclient.Tuple arg) {
        return arg != null ? new Tuple(arg) : null;
    }
}

