/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class UniRetryAtMost<T>
extends UniOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final long maxAttempts;

    public UniRetryAtMost(Uni<T> upstream, Predicate<? super Throwable> predicate, long maxAttempts) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
        this.maxAttempts = ParameterValidation.positive(maxAttempts, "maxAttempts");
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniRetryAtMostProcessor(subscriber));
    }

    private class UniRetryAtMostProcessor
    extends UniOperatorProcessor<T, T> {
        private final AtomicInteger counter;

        public UniRetryAtMostProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
            this.counter = new AtomicInteger(0);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            int count = this.counter.incrementAndGet();
            if (this.upstream.compareAndSet(null, subscription)) {
                if (count == 1) {
                    this.downstream.onSubscribe(this);
                }
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.isCancelled()) {
                Infrastructure.handleDroppedException(failure);
                return;
            }
            if (!this.testPredicate(failure)) {
                return;
            }
            if ((long)this.counter.get() > UniRetryAtMost.this.maxAttempts) {
                this.downstream.onFailure(failure);
                return;
            }
            UniSubscription previousSubscription = this.upstream.getAndSet(null);
            if (previousSubscription != null) {
                previousSubscription.cancel();
            }
            AbstractUni.subscribe(UniRetryAtMost.this.upstream(), this);
        }

        private boolean testPredicate(Throwable failure) {
            boolean passes;
            try {
                passes = UniRetryAtMost.this.predicate.test(failure);
            }
            catch (Throwable e) {
                this.downstream.onFailure(e);
                return false;
            }
            if (!passes) {
                this.downstream.onFailure(failure);
                return false;
            }
            return true;
        }
    }
}

