/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class UniSerializedSubscriber<T>
implements UniSubscriber<T>,
UniSubscription {
    private static final int INIT = 0;
    private static final int SUBSCRIBED = 1;
    private static final int HAS_SUBSCRIPTION = 2;
    private static final int DONE = 3;
    private final AtomicInteger state = new AtomicInteger(0);
    private final AbstractUni<T> upstream;
    private final UniSubscriber<? super T> downstream;
    private volatile UniSubscription subscription;
    private final AtomicReference<Throwable> failure = new AtomicReference();

    UniSerializedSubscriber(AbstractUni<T> upstream, UniSubscriber<? super T> subscriber) {
        this.upstream = ParameterValidation.nonNull(upstream, "source");
        this.downstream = ParameterValidation.nonNull(subscriber, "subscriber` must not be `null`");
    }

    public static <T> void subscribe(AbstractUni<T> source, UniSubscriber<? super T> subscriber) {
        UniSubscriber<? super T> actual = Infrastructure.onUniSubscription(source, subscriber);
        UniSerializedSubscriber<? super T> wrapped = new UniSerializedSubscriber<T>(source, actual);
        super.subscribe();
    }

    private void subscribe() {
        if (this.state.compareAndSet(0, 1)) {
            this.upstream.subscribing(this);
        }
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        ParameterValidation.nonNull(subscription, "subscription");
        if (this.state.compareAndSet(1, 2)) {
            this.subscription = subscription;
            this.downstream.onSubscribe(this);
        } else if (this.state.get() == 3) {
            Throwable collected = this.failure.getAndSet(null);
            if (collected != null) {
                this.downstream.onSubscribe(this);
                this.downstream.onFailure(collected);
            }
        } else {
            EmptyUniSubscription.propagateFailureEvent(this.downstream, new IllegalStateException("Invalid transition, expected to be in the SUBSCRIBED state but was in " + this.state));
        }
    }

    @Override
    public void onItem(T item) {
        if (this.state.compareAndSet(1, 3)) {
            this.failure.set(new IllegalStateException("Invalid transition, expected to be in the HAS_SUBSCRIPTION states but was in SUBSCRIBED and received onItem(" + item + ")"));
        } else if (this.state.compareAndSet(2, 3)) {
            try {
                this.downstream.onItem(item);
            }
            catch (Throwable e) {
                Infrastructure.handleDroppedException(e);
                throw e;
            }
        }
        this.dispose();
    }

    @Override
    public void onFailure(Throwable throwable) {
        if (this.state.compareAndSet(1, 3)) {
            this.failure.set(throwable);
        } else if (this.state.compareAndSet(2, 3)) {
            try {
                this.downstream.onFailure(throwable);
            }
            catch (Throwable e) {
                Infrastructure.handleDroppedException(new CompositeException(throwable, e));
                throw e;
            }
            finally {
                this.dispose();
            }
        } else {
            Infrastructure.handleDroppedException(throwable);
        }
    }

    private void dispose() {
        this.subscription = null;
    }

    @Override
    public void cancel() {
        if (this.state.compareAndSet(2, 3)) {
            while (this.subscription == null) {
            }
            if (this.subscription != null) {
                this.subscription.cancel();
                this.dispose();
            }
        } else {
            this.state.set(3);
        }
    }

    public synchronized boolean isCancelledOrDone() {
        return this.state.get() == 3;
    }
}

