/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import java.util.concurrent.atomic.AtomicLong;

abstract class MultiSpyBase<T>
extends AbstractMultiOperator<T, T> {
    private AtomicLong invocationCount = new AtomicLong();

    protected void incrementInvocationCount() {
        this.invocationCount.incrementAndGet();
    }

    public long invocationCount() {
        return this.invocationCount.get();
    }

    public boolean invoked() {
        return this.invocationCount() > 0L;
    }

    public void reset() {
        this.invocationCount.set(0L);
    }

    MultiSpyBase(Multi<? extends T> upstream) {
        super(upstream);
    }

    public String toString() {
        return "MultiSpyBase{invocationCount=" + this.invocationCount + "}";
    }
}

