/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public abstract class SwitchableSubscriptionSubscriber<O>
implements MultiSubscriber<O>,
Subscription {
    protected final MultiSubscriber<? super O> downstream;
    protected final AtomicReference<Subscription> currentUpstream = new AtomicReference();
    private long requested;
    private boolean unbounded;
    private final AtomicReference<Subscription> pendingSubscription = new AtomicReference();
    private final AtomicLong missedRequested = new AtomicLong();
    private final AtomicLong missedItems = new AtomicLong();
    private final AtomicInteger wip = new AtomicInteger();
    private final AtomicBoolean cancelled = new AtomicBoolean();

    public SwitchableSubscriptionSubscriber(MultiSubscriber<? super O> downstream) {
        this.downstream = downstream;
    }

    public void cancel() {
        if (!this.cancelled.getAndSet(true)) {
            this.drain();
        }
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public void onCompletion() {
        this.downstream.onComplete();
    }

    @Override
    public void onFailure(Throwable t) {
        this.downstream.onError(t);
    }

    public void onSubscribe(Subscription s) {
        this.setOrSwitchUpstream(s);
    }

    public void emitted(long n) {
        if (this.unbounded) {
            return;
        }
        if (this.wip.compareAndSet(0, 1)) {
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                long u = r - n;
                if (u < 0L) {
                    u = 0L;
                }
                this.requested = u;
            } else {
                this.unbounded = true;
            }
            if (this.wip.decrementAndGet() == 0) {
                return;
            }
            this.drainLoop();
            return;
        }
        Subscriptions.add(this.missedItems, n);
        this.drain();
    }

    public final void request(long n) {
        if (n <= 0L) {
            this.downstream.onError(Subscriptions.getInvalidRequestException());
            return;
        }
        if (this.unbounded) {
            return;
        }
        if (this.wip.compareAndSet(0, 1)) {
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                this.requested = r = Subscriptions.add(r, n);
                if (r == Long.MAX_VALUE) {
                    this.unbounded = true;
                }
            }
            Subscription actual = this.currentUpstream.get();
            if (this.wip.decrementAndGet() != 0) {
                this.drainLoop();
            }
            if (actual != null) {
                actual.request(n);
            }
            return;
        }
        Subscriptions.add(this.missedRequested, n);
        this.drain();
    }

    protected final void setOrSwitchUpstream(Subscription newUpstream) {
        ParameterValidation.nonNull(newUpstream, "newUpstream");
        if (this.cancelled.get()) {
            newUpstream.cancel();
            return;
        }
        if (this.wip.compareAndSet(0, 1)) {
            Subscription actual = this.currentUpstream.getAndSet(newUpstream);
            if (actual != null && this.cancelUpstreamOnSwitch()) {
                actual.cancel();
            }
            long r = this.requested;
            if (this.wip.decrementAndGet() != 0) {
                this.drainLoop();
            }
            if (r != 0L) {
                newUpstream.request(r);
            }
        } else {
            Subscription actual = this.currentUpstream.getAndSet(newUpstream);
            if (actual != null && this.cancelUpstreamOnSwitch()) {
                actual.cancel();
            }
            this.drain();
        }
    }

    protected boolean cancelUpstreamOnSwitch() {
        return false;
    }

    private void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    private void drainLoop() {
        int missed = 1;
        long requestAmount = 0L;
        Subscription requestTarget = null;
        do {
            Subscription nextUpstream = this.pendingSubscription.getAndSet(null);
            long pendingRequests = this.missedRequested.getAndSet(0L);
            long pendingItems = this.missedItems.getAndSet(0L);
            Subscription upstream = this.currentUpstream.get();
            if (this.cancelled.get()) {
                if (upstream != null) {
                    upstream.cancel();
                    this.currentUpstream.set(null);
                }
                if (nextUpstream == null) continue;
                nextUpstream.cancel();
                continue;
            }
            long req = this.requested;
            if (req != Long.MAX_VALUE) {
                long res = Subscriptions.add(req, pendingRequests);
                if (res != Long.MAX_VALUE) {
                    long remaining = res - pendingItems;
                    if (remaining < 0L) {
                        remaining = 0L;
                    }
                    req = remaining;
                } else {
                    req = res;
                }
                this.requested = req;
            }
            if (nextUpstream != null) {
                if (upstream != null && this.cancelUpstreamOnSwitch()) {
                    upstream.cancel();
                }
                this.currentUpstream.set(nextUpstream);
                if (req == 0L) continue;
                requestAmount = Subscriptions.add(requestAmount, req);
                requestTarget = nextUpstream;
                continue;
            }
            if (pendingRequests == 0L || upstream == null) continue;
            requestAmount = Subscriptions.add(requestAmount, pendingRequests);
            requestTarget = upstream;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
        if (requestAmount != 0L) {
            requestTarget.request(requestAmount);
        }
    }
}

