/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniRepeat;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiRepetition {
    public <S, T> UniRepeat<T> uni(Supplier<S> stateSupplier, Function<S, ? extends Uni<? extends T>> producer) {
        Uni upstream = Uni.createFrom().deferred(stateSupplier, producer);
        return new UniRepeat(upstream);
    }

    public <T> UniRepeat<T> uni(Supplier<? extends Uni<? extends T>> uniSupplier) {
        Uni upstream = Uni.createFrom().deferred(uniSupplier);
        return new UniRepeat(upstream);
    }

    public <S, T> UniRepeat<T> completionStage(Supplier<S> stateSupplier, Function<S, ? extends CompletionStage<? extends T>> producer) {
        ParameterValidation.nonNull(producer, "producer");
        return this.uni(stateSupplier, (S s) -> Uni.createFrom().completionStage((CompletionStage)producer.apply(s)));
    }

    public <T> UniRepeat<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.uni(() -> Uni.createFrom().completionStage(supplier));
    }

    public <S, T> UniRepeat<T> uni(Supplier<S> stateSupplier, BiConsumer<S, UniEmitter<? super T>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.uni(stateSupplier, (S s) -> Uni.createFrom().emitter(e -> consumer.accept((Object)s, (UniEmitter)e)));
    }

    public <T> UniRepeat<T> uni(Consumer<UniEmitter<? super T>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.uni(() -> Uni.createFrom().emitter(consumer));
    }

    public <T> UniRepeat<T> supplier(Supplier<? extends T> supplier) {
        return new UniRepeat<Supplier<? extends T>>(Uni.createFrom().item(supplier));
    }

    public <S, T> UniRepeat<T> supplier(Supplier<S> stateSupplier, Function<S, ? extends T> producer) {
        return this.uni(stateSupplier, (S s) -> Uni.createFrom().item(() -> producer.apply(s)));
    }
}

