/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SerializedSubscriber<T>
implements Subscription,
MultiSubscriber<T> {
    private final Subscriber<? super T> downstream;
    private boolean emitting;
    private boolean missed;
    private volatile boolean done;
    private volatile boolean cancelled;
    private LinkedArrayNode<T> head;
    private LinkedArrayNode<T> tail;
    private Throwable failure;
    private AtomicReference<Subscription> upstream = new AtomicReference();

    public SerializedSubscriber(Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    public void onSubscribe(Subscription s) {
        if (this.upstream.compareAndSet(null, s)) {
            this.downstream.onSubscribe((Subscription)this);
        } else {
            s.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onItem(T t) {
        if (this.cancelled || this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.cancelled || this.done) {
                return;
            }
            if (this.emitting) {
                this.serAdd(t);
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        this.downstream.onNext(t);
        this.serDrainLoop(this.downstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable t) {
        if (this.cancelled || this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.cancelled || this.done) {
                return;
            }
            this.done = true;
            this.failure = t;
            if (this.emitting) {
                this.missed = true;
                return;
            }
        }
        this.downstream.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion() {
        if (this.cancelled || this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.cancelled || this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                this.missed = true;
                return;
            }
        }
        this.downstream.onComplete();
    }

    public void request(long n) {
        this.upstream.get().request(n);
    }

    public void cancel() {
        this.cancelled = true;
        this.upstream.get().cancel();
    }

    void serAdd(T value) {
        LinkedArrayNode<T> t = this.tail;
        if (t == null) {
            t = new LinkedArrayNode<T>(value);
            this.head = t;
            this.tail = t;
        } else if (t.count == 16) {
            LinkedArrayNode<T> n = new LinkedArrayNode<T>(value);
            t.next = n;
            this.tail = n;
        } else {
            t.array[t.count++] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serDrainLoop(Subscriber<? super T> actual) {
        boolean d;
        do {
            LinkedArrayNode<T> n;
            Throwable e;
            if (this.cancelled) {
                return;
            }
            SerializedSubscriber serializedSubscriber = this;
            synchronized (serializedSubscriber) {
                if (this.cancelled) {
                    return;
                }
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
                d = this.done;
                e = this.failure;
                n = this.head;
                this.head = null;
                this.tail = null;
            }
            while (n != null) {
                T[] arr = n.array;
                int c = n.count;
                for (int i = 0; i < c; ++i) {
                    if (this.cancelled) {
                        return;
                    }
                    actual.onNext(arr[i]);
                }
                n = n.next;
            }
            if (this.cancelled) {
                return;
            }
            if (e == null) continue;
            actual.onError(e);
            return;
        } while (!d);
        actual.onComplete();
    }

    static final class LinkedArrayNode<T> {
        static final int DEFAULT_CAPACITY = 16;
        final T[] array = new Object[16];
        int count;
        LinkedArrayNode<T> next;

        LinkedArrayNode(T value) {
            this.array[0] = value;
            this.count = 1;
        }
    }
}

