/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.converters.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public class ToPublisher<T>
implements Function<Uni<T>, Publisher<T>> {
    public static final ToPublisher INSTANCE = new ToPublisher();

    private ToPublisher() {
    }

    @Override
    public Publisher<T> apply(final Uni<T> uni) {
        ParameterValidation.nonNull(uni, "uni");
        return subscriber -> {
            final AtomicReference upstreamSubscription = new AtomicReference();
            UniSubscription downstreamSubscription = new UniSubscription(){

                @Override
                public synchronized void request(long n) {
                    if (n <= 0L) {
                        subscriber.onError((Throwable)new IllegalArgumentException("Invalid request"));
                        return;
                    }
                    if (upstreamSubscription.get() == EmptyUniSubscription.CANCELLED) {
                        return;
                    }
                    uni.subscribe().withSubscriber(new UniSubscriber<T>(){

                        @Override
                        public void onSubscribe(UniSubscription subscription) {
                            if (!upstreamSubscription.compareAndSet(null, subscription)) {
                                subscriber.onError((Throwable)new IllegalStateException("Invalid subscription state - already have a subscription for upstream"));
                            }
                        }

                        @Override
                        public void onItem(T item) {
                            if (upstreamSubscription.getAndSet(EmptyUniSubscription.CANCELLED) != EmptyUniSubscription.CANCELLED) {
                                if (item != null) {
                                    subscriber.onNext(item);
                                }
                                subscriber.onComplete();
                            }
                        }

                        @Override
                        public void onFailure(Throwable failure) {
                            if (upstreamSubscription.getAndSet(EmptyUniSubscription.CANCELLED) != EmptyUniSubscription.CANCELLED) {
                                subscriber.onError(failure);
                            }
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    UniSubscription upstream;
                    1 var2_1 = this;
                    synchronized (var2_1) {
                        upstream = upstreamSubscription.getAndSet(EmptyUniSubscription.CANCELLED);
                    }
                    if (upstream != null) {
                        upstream.cancel();
                    }
                }
            };
            subscriber.onSubscribe((Subscription)downstreamSubscription);
        };
    }
}

