/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiDistinctOp;
import io.smallrye.mutiny.operators.multi.MultiSelectFirstOp;
import io.smallrye.mutiny.operators.multi.MultiSelectFirstUntilOtherOp;
import io.smallrye.mutiny.operators.multi.MultiSelectFirstWhileOp;
import io.smallrye.mutiny.operators.multi.MultiSelectLastOp;
import io.smallrye.mutiny.operators.multi.MultiSelectWhereOp;
import java.time.Duration;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;

public class MultiSelect<T> {
    private final Multi<T> upstream;

    public MultiSelect(Multi<T> upstream) {
        this.upstream = upstream;
    }

    public Multi<T> first() {
        return this.first(1L);
    }

    public Multi<T> last() {
        return this.last(1);
    }

    public Multi<T> first(long n) {
        return Infrastructure.onMultiCreation(new MultiSelectFirstOp<T>(this.upstream, n));
    }

    public Multi<T> last(int n) {
        return Infrastructure.onMultiCreation(new MultiSelectLastOp<T>(this.upstream, n));
    }

    public Multi<T> first(Predicate<? super T> predicate) {
        return Infrastructure.onMultiCreation(new MultiSelectFirstWhileOp<T>(this.upstream, ParameterValidation.nonNull(predicate, "predicate")));
    }

    public Multi<T> first(Duration duration) {
        Multi<Long> ticks = Multi.createFrom().ticks().startingAfter(duration).every(duration);
        return Infrastructure.onMultiCreation(new MultiSelectFirstUntilOtherOp<T, Long>(this.upstream, ticks));
    }

    public Multi<T> where(Predicate<? super T> predicate) {
        return Infrastructure.onMultiCreation(new MultiSelectWhereOp<T>(this.upstream, ParameterValidation.nonNull(predicate, "predicate")));
    }

    public Multi<T> where(Predicate<? super T> predicate, int limit) {
        return this.where(predicate).select().first(limit);
    }

    public Multi<T> when(Function<? super T, Uni<Boolean>> predicate) {
        ParameterValidation.nonNull(predicate, "predicate");
        return this.upstream.onItem().transformToMultiAndConcatenate(res -> {
            Uni uni = (Uni)predicate.apply(res);
            return uni.map(pass -> pass != false ? res : null).toMulti();
        });
    }

    public Multi<T> distinct() {
        return Infrastructure.onMultiCreation(new MultiDistinctOp<T>(this.upstream));
    }

    public Multi<T> distinct(Comparator<? super T> comparator) {
        return Infrastructure.onMultiCreation(new MultiDistinctOp<T>(this.upstream, comparator));
    }
}

