/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.spies.UniSpyBase;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;

public class UniOnItemSpy<T>
extends UniSpyBase<T> {
    private volatile T lastItem;

    UniOnItemSpy(Uni<T> upstream) {
        super(upstream);
    }

    public T lastItem() {
        return this.lastItem;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastItem = null;
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> downstream) {
        this.upstream().onItem().invoke((? super T item) -> {
            this.lastItem = item;
            this.incrementInvocationCount();
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "UniOnItemSpy{lastItem=" + this.lastItem + "} " + super.toString();
    }
}

