/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.UniConverter;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniCreateFromCompletionStage;
import io.smallrye.mutiny.operators.UniCreateFromDeferredSupplier;
import io.smallrye.mutiny.operators.UniCreateFromPublisher;
import io.smallrye.mutiny.operators.UniCreateWithEmitter;
import io.smallrye.mutiny.operators.UniNever;
import io.smallrye.mutiny.operators.uni.builders.KnownFailureUni;
import io.smallrye.mutiny.operators.uni.builders.KnownItemUni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class UniCreate {
    public static final UniCreate INSTANCE = new UniCreate();
    private static final Uni UNI_OF_NULL = Uni.createFrom().item((Object)null);

    private UniCreate() {
    }

    public <I, T> Uni<T> converter(UniConverter<I, T> converter, I instance) {
        return converter.from(instance);
    }

    public <T> Uni<T> completionStage(CompletionStage<? extends T> stage) {
        CompletionStage actual = ParameterValidation.nonNull(stage, "stage");
        return this.completionStage(() -> actual);
    }

    public <T, S> Uni<T> completionStage(Supplier<S> stateSupplier, Function<S, ? extends CompletionStage<? extends T>> mapper) {
        ParameterValidation.nonNull(stateSupplier, "stateSupplier");
        ParameterValidation.nonNull(mapper, "mapper");
        AtomicBoolean once = new AtomicBoolean();
        AtomicReference state = new AtomicReference();
        return Uni.createFrom().deferred(() -> {
            try {
                this.invokeOnce(once, state, stateSupplier);
            }
            catch (Throwable e) {
                return Uni.createFrom().failure(e);
            }
            Object sharedState = state.get();
            if (sharedState == null) {
                return Uni.createFrom().failure(new IllegalStateException("Invalid shared state"));
            }
            return Uni.createFrom().completionStage((CompletionStage)mapper.apply(sharedState));
        });
    }

    public <T> Uni<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        return Infrastructure.onUniCreation(new UniCreateFromCompletionStage(ParameterValidation.nonNull(supplier, "supplier")));
    }

    public <T> Uni<T> publisher(Publisher<? extends T> publisher) {
        Publisher<? extends T> actual = ParameterValidation.nonNull(publisher, "publisher");
        return Infrastructure.onUniCreation(new UniCreateFromPublisher<T>(actual));
    }

    public <T> Uni<T> item(Supplier<? extends T> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Object item;
            try {
                item = actual.get();
            }
            catch (RuntimeException e) {
                emitter.fail(e);
                return;
            }
            emitter.complete(item);
        });
    }

    public <T, S> Uni<T> item(Supplier<S> stateSupplier, Function<S, ? extends T> mapper) {
        ParameterValidation.nonNull(stateSupplier, "stateSupplier");
        ParameterValidation.nonNull(mapper, "mapper");
        AtomicBoolean once = new AtomicBoolean();
        AtomicReference state = new AtomicReference();
        return Uni.createFrom().deferred(() -> {
            try {
                this.invokeOnce(once, state, stateSupplier);
            }
            catch (Throwable e) {
                return Uni.createFrom().failure(e);
            }
            Object sharedState = state.get();
            if (sharedState == null) {
                return Uni.createFrom().failure(new IllegalStateException("Invalid shared state"));
            }
            return Uni.createFrom().item(mapper.apply(sharedState));
        });
    }

    public <T> Uni<T> item(T item) {
        return Infrastructure.onUniCreation(new KnownItemUni<T>(item));
    }

    public Uni<Void> voidItem() {
        return this.nullItem();
    }

    public <T> Uni<T> nullItem() {
        return UNI_OF_NULL;
    }

    public <T> Uni<T> optional(Optional<T> optional) {
        Optional actual = ParameterValidation.nonNull(optional, "optional");
        return this.optional(() -> actual);
    }

    public <T> Uni<T> optional(Supplier<Optional<T>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.item((T)((Supplier<Object>)() -> ((Optional)actual.get()).orElse(null)));
    }

    public <T> Uni<T> emitter(Consumer<UniEmitter<? super T>> consumer) {
        Consumer<UniEmitter<? super T>> actual = ParameterValidation.nonNull(consumer, "consumer");
        return Infrastructure.onUniCreation(new UniCreateWithEmitter<T>(actual));
    }

    public <T, S> Uni<T> emitter(Supplier<S> stateSupplier, BiConsumer<S, UniEmitter<? super T>> consumer) {
        BiConsumer actual = ParameterValidation.nonNull(consumer, "consumer");
        ParameterValidation.nonNull(stateSupplier, "stateSupplier");
        AtomicBoolean once = new AtomicBoolean();
        AtomicReference state = new AtomicReference();
        return Uni.createFrom().deferred(() -> {
            try {
                this.invokeOnce(once, state, stateSupplier);
            }
            catch (Throwable e2) {
                return Uni.createFrom().failure(e2);
            }
            Object sharedState = state.get();
            if (sharedState == null) {
                return Uni.createFrom().failure(new IllegalStateException("Invalid shared state"));
            }
            return Uni.createFrom().emitter(e -> actual.accept((Object)sharedState, (UniEmitter)e));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> void invokeOnce(AtomicBoolean once, AtomicReference<S> container, Supplier<S> supplier) {
        if (!once.getAndSet(true)) {
            Object sharedState = null;
            try {
                sharedState = supplier.get();
                if (sharedState == null) {
                    throw new NullPointerException("The supplier returned `null`");
                }
            }
            finally {
                container.set(sharedState);
            }
        }
    }

    public <T> Uni<T> deferred(Supplier<Uni<? extends T>> supplier) {
        Supplier<Uni<? extends T>> actual = ParameterValidation.nonNull(supplier, "supplier");
        return Infrastructure.onUniCreation(new UniCreateFromDeferredSupplier<T>(actual));
    }

    public <T, S> Uni<T> deferred(Supplier<S> stateSupplier, Function<S, Uni<? extends T>> mapper) {
        ParameterValidation.nonNull(stateSupplier, "stateSupplier");
        ParameterValidation.nonNull(mapper, "mapper");
        AtomicBoolean once = new AtomicBoolean();
        AtomicReference state = new AtomicReference();
        return Uni.createFrom().deferred(() -> {
            try {
                this.invokeOnce(once, state, stateSupplier);
            }
            catch (Throwable e) {
                return Uni.createFrom().failure(e);
            }
            Object sharedState = state.get();
            if (sharedState == null) {
                return Uni.createFrom().failure(new IllegalStateException("Invalid shared state"));
            }
            return (Uni)mapper.apply(sharedState);
        });
    }

    public <T> Uni<T> failure(Throwable failure) {
        return Infrastructure.onUniCreation(new KnownFailureUni(ParameterValidation.nonNull(failure, "failure")));
    }

    public <T> Uni<T> failure(Supplier<Throwable> supplier) {
        Supplier<Throwable> actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Throwable throwable;
            try {
                throwable = (Throwable)actual.get();
            }
            catch (Throwable e) {
                emitter.fail(e);
                return;
            }
            if (throwable == null) {
                emitter.fail(new NullPointerException("The supplier returned `null`"));
            } else {
                emitter.fail(throwable);
            }
        });
    }

    public <T> Uni<T> nothing() {
        return UniNever.INSTANCE;
    }

    public <T> Uni<T> multi(Multi<T> multi) {
        ParameterValidation.nonNull(multi, "multi");
        return multi.toUni();
    }
}

