/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.inject.InjectionMessages;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.Converter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

final class ConfigMappingInterface
implements ConfigMappingMetadata {
    static final ConfigMappingInterface[] NO_TYPES = new ConfigMappingInterface[0];
    static final Property[] NO_PROPERTIES = new Property[0];
    static final ClassValue<ConfigMappingInterface> cv = new ClassValue<ConfigMappingInterface>(){

        @Override
        protected ConfigMappingInterface computeValue(Class<?> type) {
            return ConfigMappingInterface.createConfigurationInterface(type);
        }
    };
    static final boolean usefulDebugInfo = Boolean.parseBoolean(AccessController.doPrivileged(() -> System.getProperty("io.smallrye.config.mapper.useful-debug-info")));
    private final Class<?> interfaceType;
    private final String className;
    private final ConfigMappingInterface[] superTypes;
    private final Property[] properties;
    private final Map<String, Property> propertiesByName;
    private static final String I_CLASS = org.objectweb.asm.Type.getInternalName(Class.class);
    private static final String I_COLLECTIONS = org.objectweb.asm.Type.getInternalName(Collections.class);
    private static final String I_CONFIGURATION_OBJECT = org.objectweb.asm.Type.getInternalName(ConfigMappingObject.class);
    private static final String I_CONVERTER = org.objectweb.asm.Type.getInternalName(Converter.class);
    private static final String I_MAP = org.objectweb.asm.Type.getInternalName(Map.class);
    private static final String I_MAPPING_CONTEXT = org.objectweb.asm.Type.getInternalName(ConfigMappingContext.class);
    private static final String I_OBJECT = org.objectweb.asm.Type.getInternalName(Object.class);
    private static final String I_OPTIONAL = org.objectweb.asm.Type.getInternalName(Optional.class);
    private static final String I_RUNTIME_EXCEPTION = org.objectweb.asm.Type.getInternalName(RuntimeException.class);
    private static final String I_SMALLRYE_CONFIG = org.objectweb.asm.Type.getInternalName(SmallRyeConfig.class);
    private static final String I_STRING_BUILDER = org.objectweb.asm.Type.getInternalName(StringBuilder.class);
    private static final String I_STRING = org.objectweb.asm.Type.getInternalName(String.class);
    private static final int V_THIS = 0;
    private static final int V_MAPPING_CONTEXT = 1;
    private static final int V_STRING_BUILDER = 2;
    private static final int V_LENGTH = 3;

    ConfigMappingInterface(Class<?> interfaceType, ConfigMappingInterface[] superTypes, Property[] properties) {
        this.interfaceType = interfaceType;
        this.className = this.getClass().getPackage().getName() + "." + interfaceType.getSimpleName() + interfaceType.getName().hashCode() + "Impl";
        this.superTypes = superTypes;
        this.properties = properties;
        this.propertiesByName = Stream.of(properties).collect(Collectors.toMap(p -> p.getMethod().getName(), p -> p));
    }

    static ConfigMappingInterface getConfigurationInterface(Class<?> interfaceType) {
        Assert.checkNotNullParam((String)"interfaceType", interfaceType);
        return cv.get(interfaceType);
    }

    @Override
    public Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    int getSuperTypeCount() {
        return this.superTypes.length;
    }

    ConfigMappingInterface getSuperType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.superTypes.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.superTypes[index];
    }

    int getPropertyCount() {
        return this.properties.length;
    }

    Property getProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.properties.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.properties[index];
    }

    Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    List<ConfigMappingInterface> getNested() {
        ArrayList<ConfigMappingInterface> nested = new ArrayList<ConfigMappingInterface>();
        ConfigMappingInterface.getNested(this.properties, nested);
        return nested;
    }

    static void getNested(Property[] properties, List<ConfigMappingInterface> nested) {
        for (Property property : properties) {
            OptionalProperty optionalProperty;
            if (property instanceof GroupProperty) {
                GroupProperty groupProperty = (GroupProperty)property;
                ConfigMappingInterface group = groupProperty.getGroupType();
                nested.add(group);
                ConfigMappingInterface.getNested(group.properties, nested);
            }
            if (!(property instanceof OptionalProperty) || !((optionalProperty = (OptionalProperty)property).getNestedProperty() instanceof GroupProperty)) continue;
            GroupProperty groupProperty = (GroupProperty)optionalProperty.getNestedProperty();
            ConfigMappingInterface group = groupProperty.getGroupType();
            nested.add(group);
            ConfigMappingInterface.getNested(group.properties, nested);
        }
    }

    static ConfigMappingInterface createConfigurationInterface(Class<?> interfaceType) {
        if (!interfaceType.isInterface() || interfaceType.getTypeParameters().length != 0) {
            return null;
        }
        ConfigMappingInterface[] superTypes = ConfigMappingInterface.getSuperTypes(interfaceType.getInterfaces(), 0, 0);
        Property[] properties = ConfigMappingInterface.getProperties(interfaceType.getDeclaredMethods(), 0, 0);
        if (superTypes.length == 0 && properties.length == 0) {
            return null;
        }
        return new ConfigMappingInterface(interfaceType, superTypes, properties);
    }

    private void addProperties(ClassVisitor cv, String className, MethodVisitor ctor, MethodVisitor fio, Set<String> visited) {
        for (Property property : this.properties) {
            Label _done;
            Label _continue;
            Method method = property.getMethod();
            String memberName = method.getName();
            if (!visited.add(memberName)) continue;
            String fieldType = org.objectweb.asm.Type.getInternalName(method.getReturnType());
            String fieldDesc = org.objectweb.asm.Type.getDescriptor(method.getReturnType());
            cv.visitField(2, memberName, fieldDesc, null, null);
            boolean optional = property.isOptional();
            Property realProperty = optional ? property.asOptional().getNestedProperty() : property;
            if (property.isMap()) {
                ctor.visitMethodInsn(184, I_COLLECTIONS, "emptyMap", "()L" + I_MAP + ';', false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitVarInsn(25, 1);
                fio.visitLdcInsn((Object)org.objectweb.asm.Type.getType(this.interfaceType));
                fio.visitLdcInsn((Object)memberName);
                fio.visitVarInsn(25, 0);
                fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";)L" + I_OBJECT + ';', false);
                fio.visitInsn(89);
                _continue = new Label();
                _done = new Label();
                fio.visitJumpInsn(198, _continue);
                fio.visitTypeInsn(192, I_MAP);
                fio.visitVarInsn(25, 0);
                fio.visitInsn(95);
                fio.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitJumpInsn(167, _done);
                fio.visitLabel(_continue);
                fio.visitInsn(87);
                fio.visitLabel(_done);
            } else if (property.isGroup()) {
                boolean restoreLength = this.appendPropertyName(ctor, property, memberName);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)org.objectweb.asm.Type.getType(realProperty.asGroup().getGroupType().getInterfaceType()));
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "constructGroup", "(L" + I_CLASS + ";)L" + I_OBJECT + ';', false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                if (restoreLength) {
                    this.restoreLength(ctor);
                }
            } else if (property.isLeaf() || property.isPrimitive() || property.isOptional() && property.isLeaf()) {
                ctor.visitVarInsn(25, 0);
                boolean restoreLength = this.appendPropertyName(ctor, property, memberName);
                ctor.visitVarInsn(25, 1);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getConfig", "()L" + I_SMALLRYE_CONFIG + ';', false);
                ctor.visitVarInsn(25, 2);
                ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ';', false);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)org.objectweb.asm.Type.getType(this.getInterfaceType()));
                ctor.visitLdcInsn((Object)memberName);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getValueConverter", "(L" + I_CLASS + ";L" + I_STRING + ";)L" + I_CONVERTER + ';', false);
                Label _try = new Label();
                Label _catch = new Label();
                Label _continue2 = new Label();
                ctor.visitLabel(_try);
                if (property.isOptional()) {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getOptionalValue", "(L" + I_STRING + ";L" + I_CONVERTER + ";)L" + I_OPTIONAL + ';', false);
                } else {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getValue", "(L" + I_STRING + ";L" + I_CONVERTER + ";)L" + I_OBJECT + ';', false);
                }
                if (property.isPrimitive()) {
                    PrimitiveProperty prim = property.asPrimitive();
                    String boxType = org.objectweb.asm.Type.getInternalName(prim.getBoxType());
                    ctor.visitTypeInsn(192, boxType);
                    ctor.visitMethodInsn(182, boxType, prim.getUnboxMethodName(), prim.getUnboxMethodDescriptor(), false);
                } else if (!property.isOptional()) {
                    assert (property.isLeaf());
                    ctor.visitTypeInsn(192, fieldType);
                }
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                ctor.visitJumpInsn(167, _continue2);
                ctor.visitLabel(_catch);
                ctor.visitVarInsn(25, 1);
                ctor.visitInsn(95);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "reportProblem", "(L" + I_RUNTIME_EXCEPTION + ";)V", false);
                ctor.visitLabel(_continue2);
                if (restoreLength) {
                    this.restoreLength(ctor);
                }
                ctor.visitTryCatchBlock(_try, _catch, _catch, I_RUNTIME_EXCEPTION);
            } else if (property.isOptional()) {
                ctor.visitMethodInsn(184, I_OPTIONAL, "empty", "()L" + I_OPTIONAL + ";", false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitVarInsn(25, 1);
                fio.visitLdcInsn((Object)org.objectweb.asm.Type.getType(this.interfaceType));
                fio.visitLdcInsn((Object)memberName);
                fio.visitVarInsn(25, 0);
                fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";)L" + I_OBJECT + ';', false);
                fio.visitInsn(89);
                _continue = new Label();
                _done = new Label();
                fio.visitJumpInsn(198, _continue);
                fio.visitMethodInsn(184, I_OPTIONAL, "of", "(L" + I_OBJECT + ";)L" + I_OPTIONAL + ';', false);
                fio.visitVarInsn(25, 0);
                fio.visitInsn(95);
                fio.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitJumpInsn(167, _done);
                fio.visitLabel(_continue);
                fio.visitInsn(87);
                fio.visitLabel(_done);
            }
            MethodVisitor mv = cv.visitMethod(1, memberName, "()" + fieldDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, memberName, fieldDesc);
            if (property.isPrimitive()) {
                mv.visitInsn(property.asPrimitive().getReturnInstruction());
            } else {
                mv.visitInsn(176);
            }
            mv.visitEnd();
            mv.visitMaxs(0, 0);
        }
        for (ConfigMappingInterface superType : this.superTypes) {
            super.addProperties(cv, className, ctor, fio, visited);
        }
    }

    private boolean appendPropertyName(MethodVisitor ctor, Property property, String memberName) {
        if (property.isParentPropertyName()) {
            return false;
        }
        Label _continue = new Label();
        ctor.visitVarInsn(25, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        ctor.visitJumpInsn(153, _continue);
        ctor.visitVarInsn(25, 2);
        ctor.visitLdcInsn((Object)Character.valueOf('.'));
        ctor.visitInsn(146);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(C)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        ctor.visitLabel(_continue);
        ctor.visitVarInsn(25, 2);
        if (property.hasPropertyName()) {
            ctor.visitLdcInsn((Object)property.getPropertyName());
        } else {
            ctor.visitLdcInsn((Object)ConfigMappingProvider.skewer(memberName));
        }
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        return true;
    }

    private void restoreLength(MethodVisitor ctor) {
        ctor.visitVarInsn(25, 2);
        ctor.visitVarInsn(21, 3);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "setLength", "(I)V", false);
    }

    @Override
    public byte[] getClassBytes() {
        ClassWriter writer = new ClassWriter(3);
        Object visitor = usefulDebugInfo ? new Debugging.ClassVisitorImpl(writer) : writer;
        String classInternalName = this.className.replace('.', '/');
        visitor.visit(52, 17, classInternalName, null, I_OBJECT, new String[]{I_CONFIGURATION_OBJECT, org.objectweb.asm.Type.getInternalName(this.interfaceType)});
        visitor.visitSource(null, null);
        MethodVisitor ctor = visitor.visitMethod(1, "<init>", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        ctor.visitParameter("context", 16);
        Label ctorStart = new Label();
        Label ctorEnd = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        ctor.visitVarInsn(25, 1);
        ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getStringBuilder", "()L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(89);
        Label ctorSbStart = new Label();
        ctor.visitLabel(ctorSbStart);
        ctor.visitVarInsn(58, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        Label ctorLenStart = new Label();
        ctor.visitLabel(ctorLenStart);
        ctor.visitVarInsn(54, 3);
        MethodVisitor fio = visitor.visitMethod(1, "fillInOptionals", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        fio.visitParameter("context", 16);
        Label fioStart = new Label();
        Label fioEnd = new Label();
        fio.visitLabel(fioStart);
        fio.visitVarInsn(25, 1);
        fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getStringBuilder", "()L" + I_STRING_BUILDER + ';', false);
        fio.visitVarInsn(58, 2);
        this.addProperties((ClassVisitor)visitor, classInternalName, ctor, fio, new HashSet<String>());
        fio.visitInsn(177);
        fio.visitLabel(fioEnd);
        fio.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, fioStart, fioEnd, 1);
        fio.visitEnd();
        fio.visitMaxs(0, 0);
        ctor.visitInsn(177);
        ctor.visitLabel(ctorEnd);
        ctor.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, ctorStart, ctorEnd, 1);
        ctor.visitLocalVariable("sb", 'L' + I_STRING_BUILDER + ';', null, ctorSbStart, ctorEnd, 2);
        ctor.visitLocalVariable("len", "I", null, ctorLenStart, ctorEnd, 3);
        ctor.visitEnd();
        ctor.visitMaxs(0, 0);
        visitor.visitEnd();
        return writer.toByteArray();
    }

    private static ConfigMappingInterface[] getSuperTypes(Class<?>[] interfaces, int si, int ti) {
        if (si == interfaces.length) {
            if (ti == 0) {
                return NO_TYPES;
            }
            return new ConfigMappingInterface[ti];
        }
        Class<?> item = interfaces[si];
        ConfigMappingInterface ci = ConfigMappingInterface.getConfigurationInterface(item);
        if (ci != null) {
            ConfigMappingInterface[] array = ConfigMappingInterface.getSuperTypes(interfaces, si + 1, ti + 1);
            array[ti] = ci;
            return array;
        }
        return ConfigMappingInterface.getSuperTypes(interfaces, si + 1, ti);
    }

    private static Property[] getProperties(Method[] methods, int si, int ti) {
        if (si == methods.length) {
            if (ti == 0) {
                return NO_PROPERTIES;
            }
            return new Property[ti];
        }
        Method method = methods[si];
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || !Modifier.isAbstract(mods)) {
            return ConfigMappingInterface.getProperties(methods, si + 1, ti);
        }
        if (method.getParameterCount() > 0) {
            throw new IllegalArgumentException("Configuration methods cannot accept parameters");
        }
        if (method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("Void config methods are not allowed");
        }
        Property p = ConfigMappingInterface.getPropertyDef(method, method.getGenericReturnType());
        Property[] array = ConfigMappingInterface.getProperties(methods, si + 1, ti + 1);
        array[ti] = p;
        return array;
    }

    private static Property getPropertyDef(Method method, Type type) {
        WithDefault annotation;
        WithConverter withConverter;
        Class<? extends Converter<?>> convertWith = ConfigMappingInterface.getConvertWith(type);
        if (convertWith == null && (withConverter = method.getAnnotation(WithConverter.class)) != null) {
            convertWith = withConverter.value();
        }
        String propertyName = ConfigMappingInterface.getPropertyName(method);
        Class<?> rawType = ConfigMappingInterface.rawTypeOf(type);
        if (rawType.isPrimitive()) {
            WithDefault annotation2 = method.getAnnotation(WithDefault.class);
            return new PrimitiveProperty(method, propertyName, rawType, convertWith, annotation2 == null ? null : annotation2.value());
        }
        if (convertWith == null) {
            if (rawType == Optional.class) {
                Property nested = ConfigMappingInterface.getPropertyDef(method, ConfigMappingInterface.typeOfParameter(type, 0));
                if (nested.isMayBeOptional()) {
                    return new OptionalProperty(method, propertyName, nested.asMayBeOptional());
                }
                throw new IllegalArgumentException("Property type " + type + " cannot be optional");
            }
            if (rawType == Map.class) {
                Type keyType = ConfigMappingInterface.typeOfParameter(type, 0);
                Class<? extends Converter<?>> keyConvertWith = ConfigMappingInterface.getConvertWith(keyType);
                Type valueType = ConfigMappingInterface.typeOfParameter(type, 1);
                return new MapProperty(method, propertyName, keyType, keyConvertWith, ConfigMappingInterface.getPropertyDef(method, valueType));
            }
            ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(rawType);
            if (configurationInterface != null) {
                return new GroupProperty(method, propertyName, configurationInterface);
            }
        }
        return new LeafProperty(method, propertyName, type, convertWith, (annotation = method.getAnnotation(WithDefault.class)) == null ? null : annotation.value());
    }

    private static Class<? extends Converter<?>> getConvertWith(Type type) {
        if (type instanceof AnnotatedType) {
            WithConverter annotation = ((AnnotatedType)((Object)type)).getAnnotation(WithConverter.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }
        return null;
    }

    private static String getPropertyName(AnnotatedElement element) {
        boolean useParent = element.getAnnotation(WithParentName.class) != null;
        WithName annotation = element.getAnnotation(WithName.class);
        if (annotation != null) {
            if (useParent) {
                throw new IllegalArgumentException("Cannot specify both @ParentConfigName and @ConfigName");
            }
            String name = annotation.value();
            if (!name.isEmpty()) {
                return name;
            }
            throw new IllegalArgumentException("Property name is empty");
        }
        if (useParent) {
            return "";
        }
        return null;
    }

    static Type typeOfParameter(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigMappingInterface.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigMappingInterface.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds != null) {
                return ConfigMappingInterface.rawTypeOf(upperBounds[0]);
            }
            return Object.class;
        }
        throw InjectionMessages.msg.noRawType(type);
    }

    static final class Debugging {
        Debugging() {
        }

        static StackTraceElement getCaller() {
            return new Throwable().getStackTrace()[2];
        }

        static final class ClassVisitorImpl
        extends ClassVisitor {
            final String sourceFile = Debugging.getCaller().getFileName();

            ClassVisitorImpl(int api) {
                super(api);
            }

            ClassVisitorImpl(ClassWriter cw) {
                super(458752, (ClassVisitor)cw);
            }

            public void visitSource(String source, String debug) {
                super.visitSource(this.sourceFile, debug);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitorImpl(this.api, super.visitMethod(access, name, descriptor, signature, exceptions));
            }
        }

        static final class MethodVisitorImpl
        extends MethodVisitor {
            MethodVisitorImpl(int api) {
                super(api);
            }

            MethodVisitorImpl(int api, MethodVisitor methodVisitor) {
                super(api, methodVisitor);
            }

            public void visitInsn(int opcode) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInsn(opcode);
            }

            public void visitIntInsn(int opcode, int operand) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIntInsn(opcode, operand);
            }

            public void visitVarInsn(int opcode, int var) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitVarInsn(opcode, var);
            }

            public void visitTypeInsn(int opcode, String type) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }

            public void visitJumpInsn(int opcode, Label label) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitJumpInsn(opcode, label);
            }

            public void visitLdcInsn(Object value) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLdcInsn(value);
            }

            public void visitIincInsn(int var, int increment) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIincInsn(var, increment);
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMultiANewArrayInsn(descriptor, numDimensions);
            }
        }
    }

    public static final class MapProperty
    extends Property {
        private final Type keyType;
        private final Class<? extends Converter<?>> keyConvertWith;
        private final Property valueProperty;

        MapProperty(Method method, String propertyName, Type keyType, Class<? extends Converter<?>> keyConvertWith, Property valueProperty) {
            super(method, propertyName);
            this.keyType = keyType;
            this.keyConvertWith = keyConvertWith;
            this.valueProperty = valueProperty;
        }

        public Type getKeyType() {
            return this.keyType;
        }

        public Class<?> getKeyRawType() {
            return ConfigMappingInterface.rawTypeOf(this.keyType);
        }

        public Class<? extends Converter<?>> getKeyConvertWith() {
            return (Class)Assert.checkNotNullParam((String)"keyConvertWith", this.keyConvertWith);
        }

        public boolean hasKeyConvertWith() {
            return this.keyConvertWith != null;
        }

        public Property getValueProperty() {
            return this.valueProperty;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public MapProperty asMap() {
            return this;
        }

        public int getLevels() {
            if (this.valueProperty.isMap()) {
                return this.valueProperty.asMap().getLevels() + 1;
            }
            return 1;
        }
    }

    public static final class LeafProperty
    extends MayBeOptionalProperty {
        private final Type valueType;
        private final Class<? extends Converter<?>> convertWith;
        private final Class<?> rawType;
        private final String defaultValue;

        LeafProperty(Method method, String propertyName, Type valueType, Class<? extends Converter<?>> convertWith, String defaultValue) {
            super(method, propertyName);
            this.valueType = valueType;
            this.convertWith = convertWith;
            this.rawType = ConfigMappingInterface.rawTypeOf(valueType);
            this.defaultValue = defaultValue;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public Class<? extends Converter<?>> getConvertWith() {
            return this.convertWith;
        }

        public boolean hasConvertWith() {
            return this.convertWith != null;
        }

        public String getDefaultValue() {
            return (String)Assert.checkNotNullParam((String)"defaultValue", (Object)this.defaultValue);
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public Class<?> getValueRawType() {
            return this.rawType;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public LeafProperty asLeaf() {
            return this;
        }
    }

    public static final class GroupProperty
    extends MayBeOptionalProperty {
        private final ConfigMappingInterface groupType;

        GroupProperty(Method method, String propertyName, ConfigMappingInterface groupType) {
            super(method, propertyName);
            this.groupType = groupType;
        }

        public ConfigMappingInterface getGroupType() {
            return this.groupType;
        }

        @Override
        public boolean isGroup() {
            return true;
        }

        @Override
        public GroupProperty asGroup() {
            return this;
        }
    }

    public static final class OptionalProperty
    extends Property {
        private final MayBeOptionalProperty nestedProperty;

        OptionalProperty(Method method, String propertyName, MayBeOptionalProperty nestedProperty) {
            super(method, propertyName);
            this.nestedProperty = nestedProperty;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public OptionalProperty asOptional() {
            return this;
        }

        @Override
        public boolean isLeaf() {
            return this.nestedProperty.isLeaf();
        }

        public MayBeOptionalProperty getNestedProperty() {
            return this.nestedProperty;
        }
    }

    public static final class PrimitiveProperty
    extends Property {
        private static final Map<Class<?>, Class<?>> boxTypes;
        private static final Map<Class<?>, String> unboxMethodName;
        private static final Map<Class<?>, String> unboxMethodDesc;
        private final Class<?> primitiveType;
        private final Class<? extends Converter<?>> convertWith;
        private final String defaultValue;

        PrimitiveProperty(Method method, String propertyName, Class<?> primitiveType, Class<? extends Converter<?>> convertWith, String defaultValue) {
            super(method, propertyName);
            this.primitiveType = primitiveType;
            this.convertWith = convertWith;
            this.defaultValue = defaultValue;
        }

        public Class<?> getPrimitiveType() {
            return this.primitiveType;
        }

        public Class<?> getBoxType() {
            return boxTypes.get(this.primitiveType);
        }

        public Class<? extends Converter<?>> getConvertWith() {
            return (Class)Assert.checkNotNullParam((String)"convertWith", this.convertWith);
        }

        public boolean hasConvertWith() {
            return this.convertWith != null;
        }

        public String getDefaultValue() {
            return (String)Assert.checkNotNullParam((String)"defaultValue", (Object)this.defaultValue);
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public PrimitiveProperty asPrimitive() {
            return this;
        }

        String getUnboxMethodName() {
            return unboxMethodName.get(this.primitiveType);
        }

        String getUnboxMethodDescriptor() {
            return unboxMethodDesc.get(this.primitiveType);
        }

        int getReturnInstruction() {
            if (this.primitiveType == Float.TYPE) {
                return 174;
            }
            if (this.primitiveType == Double.TYPE) {
                return 175;
            }
            if (this.primitiveType == Long.TYPE) {
                return 173;
            }
            return 172;
        }

        static {
            HashMap map = new HashMap();
            map.put(Byte.TYPE, Byte.class);
            map.put(Short.TYPE, Short.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Float.TYPE, Float.class);
            map.put(Double.TYPE, Double.class);
            map.put(Boolean.TYPE, Boolean.class);
            map.put(Character.TYPE, Character.class);
            boxTypes = map;
            HashMap<Class<Object>, String> nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "byteValue");
            nameMap.put(Short.TYPE, "shortValue");
            nameMap.put(Integer.TYPE, "intValue");
            nameMap.put(Long.TYPE, "longValue");
            nameMap.put(Float.TYPE, "floatValue");
            nameMap.put(Double.TYPE, "doubleValue");
            nameMap.put(Boolean.TYPE, "booleanValue");
            nameMap.put(Character.TYPE, "charValue");
            unboxMethodName = nameMap;
            nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "()B");
            nameMap.put(Short.TYPE, "()S");
            nameMap.put(Integer.TYPE, "()I");
            nameMap.put(Long.TYPE, "()J");
            nameMap.put(Float.TYPE, "()F");
            nameMap.put(Double.TYPE, "()D");
            nameMap.put(Boolean.TYPE, "()Z");
            nameMap.put(Character.TYPE, "()C");
            unboxMethodDesc = nameMap;
            nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "B");
            nameMap.put(Short.TYPE, "S");
            nameMap.put(Integer.TYPE, "I");
            nameMap.put(Long.TYPE, "J");
            nameMap.put(Float.TYPE, "F");
            nameMap.put(Double.TYPE, "D");
            nameMap.put(Boolean.TYPE, "Z");
            nameMap.put(Character.TYPE, "C");
        }
    }

    public static abstract class MayBeOptionalProperty
    extends Property {
        MayBeOptionalProperty(Method method, String propertyName) {
            super(method, propertyName);
        }

        @Override
        public boolean isMayBeOptional() {
            return true;
        }

        @Override
        public MayBeOptionalProperty asMayBeOptional() {
            return this;
        }
    }

    public static abstract class Property {
        private final Method method;
        private final String propertyName;

        Property(Method method, String propertyName) {
            this.method = method;
            this.propertyName = propertyName;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getPropertyName() {
            return Assert.checkNotEmptyParam((String)"propertyName", (String)((String)Assert.checkNotNullParam((String)"propertyName", (Object)this.propertyName)));
        }

        public boolean hasPropertyName() {
            return this.propertyName != null;
        }

        public boolean isParentPropertyName() {
            return this.hasPropertyName() && this.propertyName.isEmpty();
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isOptional() {
            return false;
        }

        public boolean isGroup() {
            return false;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean isMap() {
            return false;
        }

        public boolean isMayBeOptional() {
            return false;
        }

        public PrimitiveProperty asPrimitive() {
            throw new ClassCastException();
        }

        public OptionalProperty asOptional() {
            throw new ClassCastException();
        }

        public GroupProperty asGroup() {
            throw new ClassCastException();
        }

        public LeafProperty asLeaf() {
            throw new ClassCastException();
        }

        public MapProperty asMap() {
            throw new ClassCastException();
        }

        public MayBeOptionalProperty asMayBeOptional() {
            throw new ClassCastException();
        }
    }
}

