package io.smallrye.config;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.util.regex.Pattern;
import java.io.Serializable;
import java.lang.SecurityException;
import java.lang.String;
import java.lang.Throwable;
import org.eclipse.microprofile.config.spi.Converter;
import java.lang.Object;
import java.io.InvalidObjectException;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;

/**
 * Warning this class consists of generated code.
 */
public class ConfigMessages_$bundle implements ConfigMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected ConfigMessages_$bundle() {}
    public static final ConfigMessages_$bundle INSTANCE = new ConfigMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String fileNotFound$str() {
        return "The file %s was not found";
    }
    @Override
    public final IllegalStateException fileNotFound(final String fileName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), fileNotFound$str(), fileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String failedToLoadConfig$str() {
        return "SRCFG00001: Failure while loading microprofile-config.properties files";
    }
    @Override
    public final IllegalStateException failedToLoadConfig(final Throwable throwable) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToLoadConfig$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedCharacterConversion$str() {
        return "SRCFG00002: %s can not be converted to a Character";
    }
    @Override
    public final IllegalArgumentException failedCharacterConversion(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failedCharacterConversion$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String singleTypeConverter$str() {
        return "SRCFG00003: Converter %s must be parameterized with a single type";
    }
    @Override
    public final IllegalStateException singleTypeConverter(final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), singleTypeConverter$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notArrayType$str() {
        return "SRCFG00004: %s is not an array type";
    }
    @Override
    public final IllegalArgumentException notArrayType(final String arrayType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notArrayType$str(), arrayType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String valueNotMatchPattern$str() {
        return "SRCFG00005: Value does not match pattern %s (value was \"%s\")";
    }
    @Override
    public final IllegalArgumentException valueNotMatchPattern(final Pattern pattern, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), valueNotMatchPattern$str(), pattern, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String lessThanMinimumValue$str() {
        return "SRCFG00006: Value must not be less than %s (value was \"%s\")";
    }
    @Override
    public final IllegalArgumentException lessThanMinimumValue(final Object minimum, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), lessThanMinimumValue$str(), minimum, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String lessThanEqualToMinimumValue$str() {
        return "SRCFG00007: Value must not be less than or equal to %s (value was \"%s\")";
    }
    @Override
    public final IllegalArgumentException lessThanEqualToMinimumValue(final Object minimum, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), lessThanEqualToMinimumValue$str(), minimum, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String greaterThanMaximumValue$str() {
        return "SRCFG00008: Value must not be greater than %s (value was \"%s\")";
    }
    @Override
    public final IllegalArgumentException greaterThanMaximumValue(final Object maximum, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), greaterThanMaximumValue$str(), maximum, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String greaterThanEqualToMaximumValue$str() {
        return "SRCFG00009: Value must not be greater than or equal to %s (value was \"%s\")";
    }
    @Override
    public final IllegalArgumentException greaterThanEqualToMaximumValue(final Object maximum, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), greaterThanEqualToMaximumValue$str(), maximum, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownConverterId$str() {
        return "SRCFG00010: Unknown converter ID: %s";
    }
    @Override
    public final InvalidObjectException unknownConverterId(final int id) {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), unknownConverterId$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expandingElementNotFound$str() {
        return "SRCFG00011: Could not expand value %s in property %s";
    }
    @Override
    public final NoSuchElementException expandingElementNotFound(final String key, final String valueName) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), expandingElementNotFound$str(), key, valueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToAddConverter$str() {
        return "SRCFG00012: Can not add converter %s that is not parameterized with a type";
    }
    @Override
    public final IllegalStateException unableToAddConverter(final Converter<?> converter) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToAddConverter$str(), converter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRegisteredConverter$str() {
        return "SRCFG00013: No Converter registered for %s";
    }
    @Override
    public final IllegalArgumentException noRegisteredConverter(final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRegisteredConverter$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String propertyNotFound$str() {
        return "SRCFG00014: Property %s not found";
    }
    @Override
    public final NoSuchElementException propertyNotFound(final String name) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), propertyNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfigForClassloader$str() {
        return "SRCFG00015: No configuration is available for this class loader";
    }
    @Override
    public final IllegalStateException noConfigForClassloader() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noConfigForClassloader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configIsNull$str() {
        return "SRCFG00016: config cannot be null";
    }
    @Override
    public final IllegalArgumentException configIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), configIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configAlreadyRegistered$str() {
        return "SRCFG00017: Configuration already registered for the given class loader";
    }
    @Override
    public final IllegalStateException configAlreadyRegistered() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configAlreadyRegistered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String malformedEncoding$str() {
        return "SRCFG00018: Malformed \\uxxxx encoding";
    }
    @Override
    public final IllegalArgumentException malformedEncoding() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), malformedEncoding$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String constructorConverterFailure$str() {
        return "SRCFG00019: Failed to create new instance from Converter constructor";
    }
    @Override
    public final IllegalArgumentException constructorConverterFailure(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), constructorConverterFailure$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String staticMethodConverterFailure$str() {
        return "SRCFG00020: Failed to convert value with static method";
    }
    @Override
    public final IllegalArgumentException staticMethodConverterFailure(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), staticMethodConverterFailure$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String classConverterNotFound$str() {
        return "SRCFG00021: Converter class %s not found";
    }
    @Override
    public final IllegalArgumentException classConverterNotFound(final Throwable cause, final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), classConverterNotFound$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownHost$str() {
        return "SRCFG00022: Host, %s, not found";
    }
    @Override
    public final IllegalArgumentException unknownHost(final Throwable cause, final String host) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownHost$str(), host), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownArrayType$str() {
        return "SRCFG00023: Array type being converted is unknown";
    }
    @Override
    public final IllegalArgumentException unknownArrayType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownArrayType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAllowed$str() {
        return "SRCFG00024: Not allowed to access secret key %s";
    }
    @Override
    public final SecurityException notAllowed(final String name) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), notAllowed$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expressionExpansionTooDepth$str() {
        return "SRCFG00025: Recursive expression expansion is too deep for %s";
    }
    @Override
    public final IllegalArgumentException expressionExpansionTooDepth(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expressionExpansionTooDepth$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String malformedUUID$str() {
        return "SRCFG00026: %s cannot be converted into a UUID";
    }
    @Override
    public final IllegalArgumentException malformedUUID(final Throwable cause, final String malformedUUID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), malformedUUID$str(), malformedUUID), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mappingNotFound$str() {
        return "SRCFG00027: Could not find a mapping for %s";
    }
    @Override
    public final NoSuchElementException mappingNotFound(final String className) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), mappingNotFound$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mappingPrefixNotFound$str() {
        return "SRCFG00028: Could not find a mapping for %s with prefix %s";
    }
    @Override
    public final NoSuchElementException mappingPrefixNotFound(final String className, final String prefix) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), mappingPrefixNotFound$str(), className, prefix));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
