/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import java.util.Iterator;

class SmallRyeConfigSourceInterceptorContext
implements ConfigSourceInterceptorContext {
    private static final long serialVersionUID = 6654406739008729337L;
    private final ConfigSourceInterceptor interceptor;
    private final ConfigSourceInterceptorContext next;
    private final SmallRyeConfig config;
    private static final ThreadLocal<RecursionCount> rcHolder = ThreadLocal.withInitial(RecursionCount::new);

    SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor interceptor, ConfigSourceInterceptorContext next, SmallRyeConfig config) {
        this.interceptor = interceptor;
        this.next = next;
        this.config = config;
    }

    @Override
    public ConfigValue proceed(String name) {
        return this.interceptor.getValue(this.next, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigValue restart(String name) {
        RecursionCount rc = rcHolder.get();
        rc.increment();
        try {
            ConfigValue configValue = this.config.interceptorChain().proceed(name);
            return configValue;
        }
        finally {
            if (rc.decrement()) {
                rcHolder.remove();
            }
        }
    }

    @Override
    public Iterator<String> iterateNames() {
        return this.interceptor.iterateNames(this.next);
    }

    static final class RecursionCount {
        int count;

        RecursionCount() {
        }

        void increment() {
            int old = this.count;
            if (old == 20) {
                throw new IllegalStateException("Too many recursive interceptor actions");
            }
            this.count = old + 1;
        }

        boolean decrement() {
            return --this.count == 0;
        }
    }
}

