/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.BeanDefinition;
import io.smallrye.beanbag.BeanInstantiationException;
import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.Scope;
import io.smallrye.common.constraint.Assert;
import java.util.Comparator;
import java.util.Set;

final class Bean<T>
implements BeanSupplier<T> {
    private static final Comparator<Bean<?>> BY_PRIORITY = Comparator.comparingInt(Bean::getPriority).reversed();
    private final BeanDefinition<T> definition;
    private volatile Result<T> result;
    static final Result<Object> MISSING = new Result<Object>(){

        @Override
        Object get(Scope scope) {
            return null;
        }
    };

    static <T> Comparator<Bean<? extends T>> byPriority() {
        return BY_PRIORITY;
    }

    Bean(BeanDefinition<T> definition) {
        this.definition = definition;
        this.result = new Pending(definition.getBeanSupplier());
    }

    BeanDefinition<T> getDefinition() {
        return this.definition;
    }

    Class<?> getType() {
        return this.definition.getType();
    }

    int getPriority() {
        return this.definition.getPriority();
    }

    String getName() {
        return this.definition.getName();
    }

    @Override
    public T get(Scope scope) throws BeanInstantiationException {
        return this.result.get(scope);
    }

    boolean matchesByType(Class<?> type) {
        Set<Class<T>> restrictedTypes = this.definition.getRestrictedTypes();
        if (!type.isAssignableFrom(this.definition.getType())) {
            return false;
        }
        if (restrictedTypes.isEmpty()) {
            return true;
        }
        for (Class<T> restrictedType : restrictedTypes) {
            if (!restrictedType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    static <T> Result<T> missing() {
        return MISSING;
    }

    public String toString() {
        return "Instance for " + String.valueOf(this.definition.getType()) + ", name=" + this.getName() + ", types=" + String.valueOf(this.definition.getRestrictedTypes());
    }

    final class Pending
    extends Result<T> {
        private final BeanSupplier<T> provider;

        Pending(BeanSupplier<T> provider) {
            Assert.checkNotNullParam((String)"provider", provider);
            this.provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        T get(Scope scope) throws BeanInstantiationException {
            Object object;
            Bean bean = Bean.this;
            synchronized (bean) {
                Result existing = Bean.this.result;
                if (existing != this) {
                    return existing.get(scope);
                }
                try {
                    object = this.provider.get(scope);
                }
                catch (BeanInstantiationException bie) {
                    Failed failed = new Failed(bie.getMessage(), bie);
                    Bean.this.result = failed;
                    return failed.get(scope);
                }
                catch (Throwable t) {
                    Failed failed = new Failed("Failed to instantiate a bean", t);
                    Bean.this.result = failed;
                    return failed.get(scope);
                }
                Bean.this.result = object == null ? Bean.missing() : new Instantiated(object);
            }
            return object;
        }
    }

    static abstract class Result<T> {
        Result() {
        }

        abstract T get(Scope var1) throws BeanInstantiationException;
    }

    static final class Instantiated<T>
    extends Result<T> {
        private final T instance;

        Instantiated(T instance) {
            this.instance = instance;
        }

        @Override
        T get(Scope scope) {
            return this.instance;
        }
    }

    static final class Failed<T>
    extends Result<T> {
        private final String message;
        private final Throwable cause;

        Failed(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        @Override
        T get(Scope scope) throws BeanInstantiationException {
            throw this.cause == null ? new BeanInstantiationException(this.message) : new BeanInstantiationException(this.message, this.cause);
        }
    }
}

