/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.InjectionException;
import io.smallrye.beanbag.Injector;
import io.smallrye.beanbag.Scope;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class MethodInjector<C, T>
implements Injector<C> {
    private final Method method;
    private final BeanSupplier<T> supplier;

    MethodInjector(Method method, BeanSupplier<T> supplier) {
        this.method = method;
        this.supplier = supplier;
    }

    @Override
    public void injectInto(Scope scope, C instance) {
        T value;
        try {
            value = this.supplier.get(scope);
        }
        catch (Throwable t) {
            throw new InjectionException("Failed to acquire value from provider for method " + this.method.getDeclaringClass().getSimpleName() + "#" + this.method.getName() + " of object " + instance, t);
        }
        try {
            this.method.invoke(instance, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InjectionException("Failed to inject value " + value + " into method " + this.method.getDeclaringClass().getSimpleName() + "#" + this.method.getName() + " of object " + instance, e);
        }
    }
}

