/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

@Recorder
public class StaticResourcesRecorder {
    public static final String META_INF_RESOURCES = "META-INF/resources";
    private static volatile Set<String> knownPaths;
    private static volatile List<Path> hotDeploymentResourcePaths;

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public void staticInit(Set<String> knownPaths) {
        StaticResourcesRecorder.knownPaths = knownPaths;
    }

    public Consumer<Route> start() {
        final ArrayList<Handler> handlers = new ArrayList<Handler>();
        if (hotDeploymentResourcePaths != null && !hotDeploymentResourcePaths.isEmpty()) {
            for (Path resourcePath : hotDeploymentResourcePaths) {
                String root = resourcePath.toAbsolutePath().toString();
                StaticHandler staticHandler = StaticHandler.create();
                staticHandler.setCachingEnabled(false);
                staticHandler.setAllowRootFileSystemAccess(true);
                staticHandler.setWebRoot(root);
                staticHandler.setDefaultContentEncoding("UTF-8");
                handlers.add(event -> {
                    try {
                        staticHandler.handle(event);
                    }
                    catch (Exception e) {
                        event.next();
                    }
                });
            }
        }
        if (!knownPaths.isEmpty()) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            StaticHandler staticHandler = StaticHandler.create((String)META_INF_RESOURCES).setDefaultContentEncoding("UTF-8");
            handlers.add(ctx -> {
                String rel;
                String string = ctx.mountPoint() == null ? ctx.normalisedPath() : (rel = ctx.normalisedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length()));
                if (knownPaths.contains(rel)) {
                    staticHandler.handle(ctx);
                } else {
                    Thread.currentThread().setContextClassLoader(currentCl);
                    ctx.next();
                }
            });
        }
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                for (Handler i : handlers) {
                    route.handler(i);
                }
            }
        };
    }
}

