/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.dev.ErrorPageGenerators;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.devmode.RemoteSyncHandler;
import io.quarkus.vertx.http.runtime.devmode.ReplacementDebugPage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class VertxHttpHotReplacementSetup
implements HotReplacementSetup {
    private volatile long nextUpdate;
    private HotReplacementContext hotReplacementContext;
    private static final long HOT_REPLACEMENT_INTERVAL = 2000L;
    private static final String HEADER_NAME = "x-quarkus-hot-deployment-done";
    private static final String CONFIG_FIX = "io.quarkus.vertx-http.devmode.config.fix";
    private static volatile Set<ConnectionBase> openConnections;

    public void setupHotDeployment(HotReplacementContext context) {
        System.setProperty("vertxweb.environment", "dev");
        this.hotReplacementContext = context;
        VertxHttpRecorder.setHotReplacement((Handler<RoutingContext>)((Handler)this::handleHotReplacementRequest), this.hotReplacementContext);
        this.hotReplacementContext.addPreScanStep(new Runnable(){

            @Override
            public void run() {
                RemoteSyncHandler.doPreScan();
            }
        });
    }

    public void handleFailedInitialStart() {
        LogManager.getLogManager().getLogger("io.vertx.core.impl.ContextImpl").setLevel(Level.SEVERE);
        VertxHttpRecorder.startServerAfterFailedStart();
    }

    public static void handleDevModeRestart() {
        if (DevConsoleManager.isDoingHttpInitiatedReload()) {
            return;
        }
        Set<ConnectionBase> cons = openConnections;
        if (cons != null) {
            for (ConnectionBase con : cons) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleHotReplacementRequest(final RoutingContext routingContext) {
        ConnectionBase connectionBase;
        if (openConnections == null) {
            Class<VertxHttpHotReplacementSetup> clazz = VertxHttpHotReplacementSetup.class;
            // MONITORENTER : io.quarkus.vertx.http.runtime.devmode.VertxHttpHotReplacementSetup.class
            if (openConnections == null) {
                openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
            }
            // MONITOREXIT : clazz
        }
        if (openConnections.add(connectionBase = (ConnectionBase)routingContext.request().connection())) {
            connectionBase.closeFuture().onComplete((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    openConnections.remove(connectionBase);
                }
            });
        }
        if (this.hotReplacementContext.getDeploymentProblem() != null && routingContext.request().path().endsWith(CONFIG_FIX)) {
            routingContext.request().setExpectMultipart(true);
            routingContext.request().endHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    ((Vertx)VertxCoreRecorder.getVertx().get()).getOrCreateContext().executeBlocking((Handler)new Handler<Promise<Object>>(){

                        public void handle(Promise<Object> promise) {
                            try {
                                String redirect = "/";
                                MultiMap attrs = routingContext.request().formAttributes();
                                HashMap<String, String> newVals = new HashMap<String, String>();
                                for (Map.Entry i : attrs) {
                                    if (((String)i.getKey()).startsWith("key.")) {
                                        newVals.put(((String)i.getKey()).substring("key.".length()), (String)i.getValue());
                                        continue;
                                    }
                                    if (!((String)i.getKey()).equals("redirect")) continue;
                                    redirect = (String)i.getValue();
                                }
                                CurrentConfig.EDITOR.accept(newVals);
                                routingContext.response().setStatusCode(HttpResponseStatus.SEE_OTHER.code()).headers().set((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)redirect);
                                routingContext.response().end();
                            }
                            catch (Throwable t) {
                                routingContext.fail(t);
                            }
                        }
                    });
                }
            });
            routingContext.request().resume();
            return;
        }
        if ((this.nextUpdate <= System.currentTimeMillis() || this.hotReplacementContext.isTest()) && !routingContext.request().headers().contains(HEADER_NAME)) {
            final ClassLoader current = Thread.currentThread().getContextClassLoader();
            ((Vertx)VertxCoreRecorder.getVertx().get()).getOrCreateContext().executeBlocking((Handler)new Handler<Promise<Boolean>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(Promise<Boolean> event) {
                    Thread.currentThread().setContextClassLoader(current);
                    boolean restart = false;
                    try {
                        block16: {
                            DevConsoleManager.setDoingHttpInitiatedReload((boolean)true);
                            4 var3_3 = this;
                            synchronized (var3_3) {
                                if (VertxHttpHotReplacementSetup.this.nextUpdate >= System.currentTimeMillis() && !VertxHttpHotReplacementSetup.this.hotReplacementContext.isTest()) break block16;
                                VertxHttpHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                                Object currentState = VertxHttpRecorder.getCurrentApplicationState();
                                try {
                                    restart = VertxHttpHotReplacementSetup.this.hotReplacementContext.doScan(true);
                                }
                                catch (Exception e) {
                                    event.fail((Throwable)new IllegalStateException("Unable to perform live reload scanning", e));
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 7] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                                    DevConsoleManager.setDoingHttpInitiatedReload((boolean)false);
                                    return;
                                }
                                if (currentState != VertxHttpRecorder.getCurrentApplicationState()) {
                                    restart = true;
                                }
                            }
                        }
                        if (VertxHttpHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem() != null) {
                            event.fail(VertxHttpHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem());
                            return;
                        }
                        if (restart) {
                            HashSet<ConnectionBase> connections = new HashSet<ConnectionBase>(openConnections);
                            for (ConnectionBase con : connections) {
                                if (con == connectionBase) continue;
                                con.close();
                            }
                        }
                    }
                    finally {
                        DevConsoleManager.setDoingHttpInitiatedReload((boolean)false);
                    }
                    event.complete((Object)restart);
                }
            }, false, (Handler)new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> event) {
                    if (event.failed()) {
                        VertxHttpHotReplacementSetup.handleDeploymentProblem(routingContext, event.cause());
                    } else {
                        boolean restart = (Boolean)event.result();
                        if (restart) {
                            routingContext.request().headers().set(VertxHttpHotReplacementSetup.HEADER_NAME, "true");
                            VertxHttpRecorder.getRootHandler().handle((Object)routingContext.request());
                        } else {
                            routingContext.next();
                        }
                    }
                }
            });
            return;
        }
        if (this.hotReplacementContext.getDeploymentProblem() != null) {
            VertxHttpHotReplacementSetup.handleDeploymentProblem(routingContext, this.hotReplacementContext.getDeploymentProblem());
            return;
        }
        routingContext.next();
    }

    public static void handleDeploymentProblem(RoutingContext routingContext, Throwable exception) {
        String bodyText = ReplacementDebugPage.generateHtml(exception, routingContext.request().absoluteURI());
        HttpServerResponse response = routingContext.response();
        response.setStatusCode(500);
        response.headers().add("Content-Type", "text/html; charset=UTF-8");
        response.end(bodyText);
    }

    public void close() {
        ErrorPageGenerators.clear();
        VertxHttpRecorder.shutDownDevMode();
    }
}

