/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;

public class QuarkusErrorHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(QuarkusErrorHandler.class);
    private static final String BASE_ID = UUID.randomUUID().toString() + "-";
    private static final AtomicLong ERROR_COUNT = new AtomicLong();
    private final boolean showStack;

    public QuarkusErrorHandler(boolean showStack) {
        this.showStack = showStack;
    }

    public void handle(RoutingContext event) {
        if (event.failure() == null) {
            event.response().setStatusCode(event.statusCode());
            event.response().end();
            return;
        }
        event.response().setStatusCode(500);
        String uuid = BASE_ID + ERROR_COUNT.incrementAndGet();
        String details = "";
        String stack = "";
        Throwable exception = event.failure();
        if (this.showStack && exception != null) {
            details = QuarkusErrorHandler.generateHeaderMessage(exception, uuid == null ? null : uuid.toString());
            stack = QuarkusErrorHandler.generateStackTrace(exception);
        } else if (uuid != null) {
            details = details + "Error id " + uuid;
        }
        log.errorf(exception, "HTTP Request to %s failed, error id: %s", (Object)event.request().uri(), (Object)uuid);
        String accept = event.request().getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8");
            String escapedStack = stack.replace(System.lineSeparator(), "\\n").replace("\"", "\\\"");
            StringBuilder jsonPayload = new StringBuilder("{\"details\":\"").append(details).append("\",\"stack\":\"").append(escapedStack).append("\"}");
            event.response().end(jsonPayload.toString());
        } else {
            event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8");
            event.response().end(new TemplateHtmlBuilder("Internal Server Error", details, details).stack(stack).toString());
        }
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return QuarkusErrorHandler.escapeHtml(stringWriter.toString().trim());
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return QuarkusErrorHandler.escapeHtml(String.format("Error handling %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorHandler.extractFirstLine(exception.getMessage())));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    private static String escapeHtml(String bodyText) {
        if (bodyText == null) {
            return "null";
        }
        return bodyText.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

