/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.vertx.deployment.VertxConstants;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.mutiny.Uni;
import io.vertx.core.eventbus.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class EventBusConsumer {
    private static final String INVOKER_SUFFIX = "_VertxInvoker";
    private static final MethodDescriptor INVOKER_CONSTRUCTOR = MethodDescriptor.ofConstructor(EventConsumerInvoker.class, (Class[])new Class[0]);
    private static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_GET = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    private static final MethodDescriptor MUTINY_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(io.vertx.mutiny.core.eventbus.Message.class, (String)"newInstance", io.vertx.mutiny.core.eventbus.Message.class, (Class[])new Class[]{Message.class});
    private static final MethodDescriptor MESSAGE_BODY = MethodDescriptor.ofMethod(Message.class, (String)"body", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_DESTROY = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]);
    protected static final MethodDescriptor WHEN_COMPLETE = MethodDescriptor.ofMethod(CompletionStage.class, (String)"whenComplete", CompletionStage.class, (Class[])new Class[]{BiConsumer.class});
    protected static final MethodDescriptor SUBSCRIBE_AS_COMPLETION_STAGE = MethodDescriptor.ofMethod(Uni.class, (String)"subscribeAsCompletionStage", CompletableFuture.class, (Class[])new Class[0]);
    protected static final MethodDescriptor THROWABLE_GET_MESSAGE = MethodDescriptor.ofMethod(Throwable.class, (String)"getMessage", String.class, (Class[])new Class[0]);
    protected static final MethodDescriptor THROWABLE_TO_STRING = MethodDescriptor.ofMethod(Throwable.class, (String)"toString", String.class, (Class[])new Class[0]);
    protected static final DotName BLOCKING = DotName.createSimple((String)Blocking.class.getName());

    static String generateInvoker(BeanInfo bean, MethodInfo method, AnnotationInstance consumeEvent, ClassOutput classOutput) {
        AnnotationValue orderedValue;
        boolean ordered;
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((ClassInfo)bean.getImplClazz()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = targetPackage + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        AnnotationValue blockingValue = consumeEvent.value("blocking");
        boolean blocking = method.hasAnnotation(BLOCKING) || blockingValue != null && blockingValue.asBoolean();
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(EventConsumerInvoker.class).build();
        FieldCreator beanField = (FieldCreator)invokerCreator.getFieldCreator("bean", InjectableBean.class).setModifiers(18);
        FieldCreator containerField = (FieldCreator)invokerCreator.getFieldCreator("container", ArcContainer.class).setModifiers(18);
        if (blocking) {
            MethodCreator isBlocking = invokerCreator.getMethodCreator("isBlocking", Boolean.TYPE, new Class[0]);
            isBlocking.returnValue(isBlocking.load(true));
        }
        boolean bl = ordered = (orderedValue = consumeEvent.value("ordered")) != null && orderedValue.asBoolean();
        if (ordered) {
            MethodCreator isOrdered = invokerCreator.getMethodCreator("isOrdered", Boolean.TYPE, new Class[0]);
            isOrdered.returnValue(isOrdered.load(true));
        }
        EventBusConsumer.implementConstructor(bean, invokerCreator, beanField, containerField);
        EventBusConsumer.implementInvoke(bean, method, invokerCreator, beanField.getFieldDescriptor(), containerField.getFieldDescriptor());
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    static void implementConstructor(BeanInfo bean, ClassCreator invokerCreator, FieldCreator beanField, FieldCreator containerField) {
        MethodCreator constructor = invokerCreator.getMethodCreator("<init>", Void.TYPE, new Class[0]);
        constructor.invokeSpecialMethod(INVOKER_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        ResultHandle containerHandle = constructor.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle beanHandle = constructor.invokeInterfaceMethod(ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{constructor.load(bean.getIdentifier())});
        constructor.writeInstanceField(beanField.getFieldDescriptor(), constructor.getThis(), beanHandle);
        constructor.writeInstanceField(containerField.getFieldDescriptor(), constructor.getThis(), containerHandle);
        constructor.returnValue(null);
    }

    private static void implementInvoke(BeanInfo bean, MethodInfo method, ClassCreator invokerCreator, FieldDescriptor beanField, FieldDescriptor containerField) {
        ResultHandle result;
        MethodCreator invoke = invokerCreator.getMethodCreator("invokeBean", Object.class, new Class[]{Message.class}).addException(Exception.class);
        ResultHandle containerHandle = invoke.readInstanceField(containerField, invoke.getThis());
        ResultHandle beanHandle = invoke.readInstanceField(beanField, invoke.getThis());
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_BEAN, containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
        ResultHandle messageHandle = invoke.getMethodParam(0);
        Type paramType = (Type)method.parameters().get(0);
        if (paramType.name().equals((Object)VertxConstants.MESSAGE)) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{Message.class}), beanInstanceHandle, new ResultHandle[]{messageHandle});
            result = invoke.loadNull();
        } else if (paramType.name().equals((Object)VertxConstants.MUTINY_MESSAGE)) {
            ResultHandle mutinyMessageHandle = invoke.invokeStaticMethod(MUTINY_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.mutiny.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{mutinyMessageHandle});
            result = invoke.loadNull();
        } else {
            ResultHandle bodyHandle = invoke.invokeInterfaceMethod(MESSAGE_BODY, messageHandle, new ResultHandle[0]);
            ResultHandle returnHandle = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)bean.getImplClazz().name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])new String[]{paramType.name().toString()}), beanInstanceHandle, new ResultHandle[]{bodyHandle});
            result = returnHandle != null ? (method.returnType().name().equals((Object)VertxConstants.COMPLETION_STAGE) ? returnHandle : (method.returnType().name().equals((Object)VertxConstants.UNI) ? invoke.invokeInterfaceMethod(SUBSCRIBE_AS_COMPLETION_STAGE, returnHandle, new ResultHandle[0]) : returnHandle)) : invoke.loadNull();
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(INSTANCE_HANDLE_DESTROY, instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(result);
    }

    private EventBusConsumer() {
    }
}

