/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.Config;

public class JarLauncher
implements ArtifactLauncher {
    private static final int DEFAULT_PORT = 8081;
    private static final int DEFAULT_HTTPS_PORT = 8444;
    private static final long DEFAULT_JAR_WAIT_TIME = 60L;
    private final Path jarPath;
    private final String profile;
    private final String argLine;
    private Process quarkusProcess;
    private final int httpPort;
    private final int httpsPort;
    private final long jarWaitTime;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private boolean isSsl;

    private JarLauncher(Path jarPath, Config config) {
        this(jarPath, ((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ((OptionalLong)config.getValue("quarkus.test.jar-wait-time", OptionalLong.class)).orElse(60L), config.getOptionalValue("quarkus.test.argLine", String.class).orElse(null), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null));
    }

    public JarLauncher(Path jarPath) {
        this(jarPath, LauncherUtil.installAndGetSomeConfig());
    }

    public JarLauncher(Path jarPath, int httpPort, int httpsPort, long jarWaitTime, String argLine, String profile) {
        this.jarPath = jarPath;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.jarWaitTime = jarWaitTime;
        this.argLine = argLine;
        this.profile = profile;
    }

    @Override
    public void start() throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        if (this.argLine != null) {
            args.add(this.argLine);
        }
        args.add("-Dquarkus.http.port=" + this.httpPort);
        args.add("-Dquarkus.http.ssl-port=" + this.httpsPort);
        args.add("-Dtest.url=" + TestHTTPResourceManager.getUri());
        Path logFile = PropertyTestUtil.getLogFilePath();
        args.add("-Dquarkus.log.file.path=" + logFile.toAbsolutePath().toString());
        args.add("-Dquarkus.log.file.enable=true");
        if (this.profile != null) {
            args.add("-Dquarkus.profile=" + this.profile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        args.add("-jar");
        args.add(this.jarPath.toAbsolutePath().toString());
        System.out.println("Executing " + args);
        Files.deleteIfExists(logFile);
        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        this.quarkusProcess = LauncherUtil.launchProcess(args);
        ListeningAddress result = LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logFile, this.jarWaitTime);
        LauncherUtil.updateConfigForPort(result.getPort());
        this.isSsl = result.isSsl();
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void addSystemProperties(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }
}

