/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler;

import io.quarkus.scheduler.ScheduledExecution;
import java.time.Instant;

public class SkippedExecution {
    public final String triggerId;
    public final Instant fireTime;
    private final ScheduledExecution execution;
    private final String detail;

    public SkippedExecution(ScheduledExecution execution) {
        this(execution, null);
    }

    public SkippedExecution(ScheduledExecution execution, String detail) {
        this.execution = execution;
        this.detail = detail;
        this.triggerId = execution.getTrigger().getId();
        this.fireTime = execution.getFireTime();
    }

    public ScheduledExecution getExecution() {
        return this.execution;
    }

    public String getDetail() {
        return this.detail;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Skipped execution of [").append(this.execution.getTrigger().getId()).append("]");
        if (this.detail != null) {
            builder.append(": ").append(this.detail);
        }
        return builder.toString();
    }
}

