/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.smallrye.config.SmallRyeConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;

@ConfigGroup
public class RestClientConfig {
    public static final RestClientConfig EMPTY = new RestClientConfig();
    @ConfigItem
    public Optional<String> url;
    @ConfigItem
    public Optional<String> uri;
    @ConfigItem
    public Optional<String> scope;
    @ConfigItem
    public Optional<String> providers;
    @ConfigItem
    public Optional<Long> connectTimeout;
    @ConfigItem
    public Optional<Long> readTimeout;
    @ConfigItem
    public Optional<Boolean> followRedirects;
    @ConfigItem
    public Optional<String> proxyAddress;
    @ConfigItem
    public Optional<String> proxyUser;
    @ConfigItem
    public Optional<String> proxyPassword;
    @ConfigItem
    public Optional<String> nonProxyHosts;
    @ConfigItem
    public Optional<QueryParamStyle> queryParamStyle;
    @ConfigItem
    public Optional<Boolean> verifyHost;
    @ConfigItem
    public Optional<String> trustStore;
    @ConfigItem
    public Optional<String> trustStorePassword;
    @ConfigItem
    public Optional<String> trustStoreType;
    @ConfigItem
    public Optional<String> keyStore;
    @ConfigItem
    public Optional<String> keyStorePassword;
    @ConfigItem
    public Optional<String> keyStoreType;
    @ConfigItem
    public Optional<String> hostnameVerifier;
    @ConfigItem
    public Optional<Integer> connectionTTL;
    @ConfigItem
    public Optional<Integer> connectionPoolSize;
    @ConfigItem
    public Optional<Boolean> keepAliveEnabled;
    @ConfigItem
    public Optional<Integer> maxRedirects;
    @ConfigItem
    public Map<String, String> headers;
    @ConfigItem
    public Optional<Boolean> shared;
    @ConfigItem
    public Optional<String> name;
    @ConfigItem
    public Optional<String> userAgent;

    public static RestClientConfig load(String configKey) {
        RestClientConfig instance = new RestClientConfig();
        instance.url = RestClientConfig.getConfigValue(configKey, "url", String.class);
        instance.uri = RestClientConfig.getConfigValue(configKey, "uri", String.class);
        instance.scope = RestClientConfig.getConfigValue(configKey, "scope", String.class);
        instance.providers = RestClientConfig.getConfigValue(configKey, "providers", String.class);
        instance.connectTimeout = RestClientConfig.getConfigValue(configKey, "connect-timeout", Long.class);
        instance.readTimeout = RestClientConfig.getConfigValue(configKey, "read-timeout", Long.class);
        instance.followRedirects = RestClientConfig.getConfigValue(configKey, "follow-redirects", Boolean.class);
        instance.proxyAddress = RestClientConfig.getConfigValue(configKey, "proxy-address", String.class);
        instance.proxyUser = RestClientConfig.getConfigValue(configKey, "proxy-user", String.class);
        instance.proxyPassword = RestClientConfig.getConfigValue(configKey, "proxy-password", String.class);
        instance.nonProxyHosts = RestClientConfig.getConfigValue(configKey, "non-proxy-hosts", String.class);
        instance.queryParamStyle = RestClientConfig.getConfigValue(configKey, "query-param-style", QueryParamStyle.class);
        instance.verifyHost = RestClientConfig.getConfigValue(configKey, "verify-host", Boolean.class);
        instance.trustStore = RestClientConfig.getConfigValue(configKey, "trust-store", String.class);
        instance.trustStorePassword = RestClientConfig.getConfigValue(configKey, "trust-store-password", String.class);
        instance.trustStoreType = RestClientConfig.getConfigValue(configKey, "trust-store-type", String.class);
        instance.keyStore = RestClientConfig.getConfigValue(configKey, "key-store", String.class);
        instance.keyStorePassword = RestClientConfig.getConfigValue(configKey, "key-store-password", String.class);
        instance.keyStoreType = RestClientConfig.getConfigValue(configKey, "key-store-type", String.class);
        instance.hostnameVerifier = RestClientConfig.getConfigValue(configKey, "hostname-verifier", String.class);
        instance.connectionTTL = RestClientConfig.getConfigValue(configKey, "connection-ttl", Integer.class);
        instance.connectionPoolSize = RestClientConfig.getConfigValue(configKey, "connection-pool-size", Integer.class);
        instance.keepAliveEnabled = RestClientConfig.getConfigValue(configKey, "keep-alive-enabled", Boolean.class);
        instance.maxRedirects = RestClientConfig.getConfigValue(configKey, "max-redirects", Integer.class);
        instance.headers = RestClientConfig.getConfigValues(configKey, "headers", String.class, String.class);
        instance.shared = RestClientConfig.getConfigValue(configKey, "shared", Boolean.class);
        instance.name = RestClientConfig.getConfigValue(configKey, "name", String.class);
        instance.userAgent = RestClientConfig.getConfigValue(configKey, "user-agent", String.class);
        return instance;
    }

    public static RestClientConfig load(Class<?> interfaceClass) {
        RestClientConfig instance = new RestClientConfig();
        instance.url = RestClientConfig.getConfigValue(interfaceClass, "url", String.class);
        instance.uri = RestClientConfig.getConfigValue(interfaceClass, "uri", String.class);
        instance.scope = RestClientConfig.getConfigValue(interfaceClass, "scope", String.class);
        instance.providers = RestClientConfig.getConfigValue(interfaceClass, "providers", String.class);
        instance.connectTimeout = RestClientConfig.getConfigValue(interfaceClass, "connect-timeout", Long.class);
        instance.readTimeout = RestClientConfig.getConfigValue(interfaceClass, "read-timeout", Long.class);
        instance.followRedirects = RestClientConfig.getConfigValue(interfaceClass, "follow-redirects", Boolean.class);
        instance.proxyAddress = RestClientConfig.getConfigValue(interfaceClass, "proxy-address", String.class);
        instance.proxyUser = RestClientConfig.getConfigValue(interfaceClass, "proxy-user", String.class);
        instance.proxyPassword = RestClientConfig.getConfigValue(interfaceClass, "proxy-password", String.class);
        instance.nonProxyHosts = RestClientConfig.getConfigValue(interfaceClass, "non-proxy-hosts", String.class);
        instance.queryParamStyle = RestClientConfig.getConfigValue(interfaceClass, "query-param-style", QueryParamStyle.class);
        instance.verifyHost = RestClientConfig.getConfigValue(interfaceClass, "verify-host", Boolean.class);
        instance.trustStore = RestClientConfig.getConfigValue(interfaceClass, "trust-store", String.class);
        instance.trustStorePassword = RestClientConfig.getConfigValue(interfaceClass, "trust-store-password", String.class);
        instance.trustStoreType = RestClientConfig.getConfigValue(interfaceClass, "trust-store-type", String.class);
        instance.keyStore = RestClientConfig.getConfigValue(interfaceClass, "key-store", String.class);
        instance.keyStorePassword = RestClientConfig.getConfigValue(interfaceClass, "key-store-password", String.class);
        instance.keyStoreType = RestClientConfig.getConfigValue(interfaceClass, "key-store-type", String.class);
        instance.hostnameVerifier = RestClientConfig.getConfigValue(interfaceClass, "hostname-verifier", String.class);
        instance.connectionTTL = RestClientConfig.getConfigValue(interfaceClass, "connection-ttl", Integer.class);
        instance.connectionPoolSize = RestClientConfig.getConfigValue(interfaceClass, "connection-pool-size", Integer.class);
        instance.keepAliveEnabled = RestClientConfig.getConfigValue(interfaceClass, "keep-alive-enabled", Boolean.class);
        instance.maxRedirects = RestClientConfig.getConfigValue(interfaceClass, "max-redirects", Integer.class);
        instance.headers = RestClientConfig.getConfigValues(interfaceClass, "headers", String.class, String.class);
        instance.shared = RestClientConfig.getConfigValue(interfaceClass, "shared", Boolean.class);
        instance.name = RestClientConfig.getConfigValue(interfaceClass, "name", String.class);
        instance.userAgent = RestClientConfig.getConfigValue(interfaceClass, "user-agent", String.class);
        return instance;
    }

    private static <T> Optional<T> getConfigValue(String configKey, String fieldName, Class<T> type) {
        Config config = ConfigProvider.getConfig();
        Optional optional = config.getOptionalValue(RestClientConfig.composePropertyKey(configKey, fieldName), type);
        if (optional.isEmpty()) {
            optional = config.getOptionalValue(RestClientConfig.composePropertyKey("\"" + configKey + "\"", fieldName), type);
        }
        return optional;
    }

    private static <T> Optional<T> getConfigValue(Class<?> clientInterface, String fieldName, Class<T> type) {
        Config config = ConfigProvider.getConfig();
        Optional optional = config.getOptionalValue(RestClientConfig.composePropertyKey("\"" + clientInterface.getName() + "\"", fieldName), type);
        if (optional.isEmpty()) {
            optional = config.getOptionalValue(RestClientConfig.composePropertyKey(clientInterface.getSimpleName(), fieldName), type);
        }
        if (optional.isEmpty()) {
            optional = config.getOptionalValue(RestClientConfig.composePropertyKey("\"" + clientInterface.getSimpleName() + "\"", fieldName), type);
        }
        return optional;
    }

    private static <K, V> Map<K, V> getConfigValues(String configKey, String fieldName, Class<K> keyType, Class<V> valueType) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        Optional optional = config.getOptionalValues(RestClientConfig.composePropertyKey(configKey, fieldName), keyType, valueType);
        if (optional.isEmpty()) {
            optional = config.getOptionalValues(RestClientConfig.composePropertyKey("\"" + configKey + "\"", fieldName), keyType, valueType);
        }
        return optional.isPresent() ? (Map)optional.get() : Collections.emptyMap();
    }

    private static <K, V> Map<K, V> getConfigValues(Class<?> clientInterface, String fieldName, Class<K> keyType, Class<V> valueType) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        Optional optional = config.getOptionalValues(RestClientConfig.composePropertyKey("\"" + clientInterface.getName() + "\"", fieldName), keyType, valueType);
        if (optional.isEmpty()) {
            optional = config.getOptionalValues(RestClientConfig.composePropertyKey(clientInterface.getSimpleName(), fieldName), keyType, valueType);
        }
        if (optional.isEmpty()) {
            optional = config.getOptionalValues(RestClientConfig.composePropertyKey("\"" + clientInterface.getSimpleName() + "\"", fieldName), keyType, valueType);
        }
        return optional.isPresent() ? (Map)optional.get() : Collections.emptyMap();
    }

    private static String composePropertyKey(String key, String fieldName) {
        return "quarkus.rest-client." + key + "." + fieldName;
    }

    static {
        RestClientConfig.EMPTY.url = Optional.empty();
        RestClientConfig.EMPTY.uri = Optional.empty();
        RestClientConfig.EMPTY.scope = Optional.empty();
        RestClientConfig.EMPTY.providers = Optional.empty();
        RestClientConfig.EMPTY.connectTimeout = Optional.empty();
        RestClientConfig.EMPTY.readTimeout = Optional.empty();
        RestClientConfig.EMPTY.followRedirects = Optional.empty();
        RestClientConfig.EMPTY.proxyAddress = Optional.empty();
        RestClientConfig.EMPTY.proxyUser = Optional.empty();
        RestClientConfig.EMPTY.proxyPassword = Optional.empty();
        RestClientConfig.EMPTY.nonProxyHosts = Optional.empty();
        RestClientConfig.EMPTY.queryParamStyle = Optional.empty();
        RestClientConfig.EMPTY.verifyHost = Optional.empty();
        RestClientConfig.EMPTY.trustStore = Optional.empty();
        RestClientConfig.EMPTY.trustStorePassword = Optional.empty();
        RestClientConfig.EMPTY.trustStoreType = Optional.empty();
        RestClientConfig.EMPTY.keyStore = Optional.empty();
        RestClientConfig.EMPTY.keyStorePassword = Optional.empty();
        RestClientConfig.EMPTY.keyStoreType = Optional.empty();
        RestClientConfig.EMPTY.hostnameVerifier = Optional.empty();
        RestClientConfig.EMPTY.connectionTTL = Optional.empty();
        RestClientConfig.EMPTY.connectionPoolSize = Optional.empty();
        RestClientConfig.EMPTY.keepAliveEnabled = Optional.empty();
        RestClientConfig.EMPTY.maxRedirects = Optional.empty();
        RestClientConfig.EMPTY.headers = Collections.emptyMap();
        RestClientConfig.EMPTY.shared = Optional.empty();
        RestClientConfig.EMPTY.name = Optional.empty();
        RestClientConfig.EMPTY.userAgent = Optional.empty();
    }
}

