/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import org.objectweb.asm.MethodVisitor;

public class PanacheFieldAccessMethodVisitor
extends MethodVisitor {
    private final String methodName;
    private String owner;
    private String methodDescriptor;
    private MetamodelInfo modelInfo;

    public PanacheFieldAccessMethodVisitor(MethodVisitor methodVisitor, String owner, String methodName, String methodDescriptor, MetamodelInfo modelInfo) {
        super(589824, methodVisitor);
        this.owner = owner;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.modelInfo = modelInfo;
    }

    public void visitFieldInsn(int opcode, String owner, String fieldName, String descriptor) {
        String ownerName = owner.replace('/', '.');
        if (!(opcode != 180 && opcode != 181 || this.methodName.equals("<init>") && this.targetIsInHierarchy(this.owner.replace('/', '.'), ownerName) || !this.isEntityField(ownerName, fieldName))) {
            String methodDescriptor;
            String methodName;
            if (opcode == 180) {
                methodName = JavaBeanUtil.getGetterName((String)fieldName, (String)descriptor);
                methodDescriptor = "()" + descriptor;
            } else {
                methodName = JavaBeanUtil.getSetterName((String)fieldName);
                methodDescriptor = "(" + descriptor + ")V";
            }
            if (!(owner.equals(this.owner) && methodName.equals(this.methodName) && methodDescriptor.equals(this.methodDescriptor))) {
                super.visitMethodInsn(182, owner, methodName, methodDescriptor, false);
            } else {
                super.visitFieldInsn(opcode, owner, fieldName, descriptor);
            }
        } else {
            super.visitFieldInsn(opcode, owner, fieldName, descriptor);
        }
    }

    private boolean targetIsInHierarchy(String currentClass, String targetClass) {
        if (currentClass.equals(targetClass)) {
            return true;
        }
        EntityModel entityModel = this.modelInfo.getEntityModel(currentClass);
        if (entityModel == null) {
            return false;
        }
        if (entityModel.superClassName != null) {
            return this.targetIsInHierarchy(entityModel.superClassName, targetClass);
        }
        return false;
    }

    boolean isEntityField(String className, String fieldName) {
        EntityModel entityModel = this.modelInfo.getEntityModel(className);
        if (entityModel == null) {
            return false;
        }
        EntityField field = entityModel.fields.get(fieldName);
        if (field != null) {
            return true;
        }
        if (entityModel.superClassName != null) {
            return this.isEntityField(entityModel.superClassName, fieldName);
        }
        return false;
    }
}

