/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;

public final class KubernetesEnvBuildItem
extends MultiBuildItem {
    private final String name;
    private final String value;
    private final EnvType type;
    private final String target;
    private final boolean oldStyle;

    public static EnvType getEnvType(String secret, String configmap, String field) {
        EnvType type = secret != null ? EnvType.secret : (configmap != null ? EnvType.configmap : (field != null ? EnvType.field : EnvType.var));
        return type;
    }

    public KubernetesEnvBuildItem(String name, String value, String target) {
        this(EnvType.var, name, value, target);
    }

    public KubernetesEnvBuildItem(EnvType type, String name, String value, String target, boolean oldStyle) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.target = target;
        this.oldStyle = oldStyle;
    }

    public KubernetesEnvBuildItem(EnvType type, String name, String value, String target) {
        this(type, name, value, target, false);
    }

    public String getConfigMap() {
        return this.getValueIfMatching(EnvType.configmap);
    }

    public String getSecret() {
        return this.getValueIfMatching(EnvType.secret);
    }

    public String getField() {
        return this.getValueIfMatching(EnvType.field);
    }

    public String getVar() {
        return this.getValueIfMatching(EnvType.var);
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    private String getValueIfMatching(EnvType type) {
        return this.type == type ? this.value : null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public EnvType getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KubernetesEnvBuildItem that = (KubernetesEnvBuildItem)((Object)o);
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.target.equals(that.target);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public static enum EnvType {
        var(false),
        field(false),
        secret(true),
        configmap(true);

        public final boolean allowMultipleDefinitions;

        private EnvType(boolean allowMultipleDefinitions) {
            this.allowMultipleDefinitions = allowMultipleDefinitions;
        }

        public boolean mightConflictWith(EnvType type) {
            if (this == type) {
                return true;
            }
            switch (this) {
                case field: {
                    return type == var;
                }
                case var: {
                    return type == field;
                }
                case secret: {
                    return type == configmap;
                }
                case configmap: {
                    return type == secret;
                }
            }
            return false;
        }
    }
}

