/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class MavenProjectBuildFile
extends BuildFile {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+)}");
    private Model model;
    private List<ArtifactCoords> managedDependencies;
    private Properties projectProps;
    private Supplier<List<ArtifactCoords>> projectDepsSupplier;
    private List<ArtifactCoords> dependencies;
    private List<ArtifactCoords> importedPlatforms;
    private MavenArtifactResolver resolver;

    public static QuarkusProject getProject(Path projectDir, MessageWriter log, Supplier<String> defaultQuarkusVersion) throws RegistryResolutionException {
        Model projectModel;
        DefaultArtifact projectPom;
        MavenArtifactResolver mvnResolver = MavenProjectBuildFile.getMavenResolver(projectDir);
        LocalProject currentProject = mvnResolver.getMavenContext().getCurrentProject();
        if (currentProject != null && MavenProjectBuildFile.isSameFile(projectDir, currentProject.getDir())) {
            projectPom = new DefaultArtifact(currentProject.getGroupId(), currentProject.getArtifactId(), null, "pom", currentProject.getVersion());
            projectModel = currentProject.getRawModel();
        } else {
            projectPom = null;
            projectModel = null;
        }
        return MavenProjectBuildFile.getProject(projectPom, projectModel, projectDir, projectModel == null ? new Properties() : projectModel.getProperties(), mvnResolver, log, defaultQuarkusVersion);
    }

    public static QuarkusProject getProject(Artifact projectPom, Model projectModel, Path projectDir, Properties projectProps, MavenArtifactResolver mvnResolver, MessageWriter log, Supplier<String> defaultQuarkusVersion) throws RegistryResolutionException {
        ExtensionCatalog extensionCatalog;
        ExtensionCatalogResolver catalogResolver;
        String quarkusVersion;
        List<Object> importedPlatforms;
        Supplier<List<ArtifactCoords>> deps;
        List<ArtifactCoords> managedDeps;
        if (projectPom == null) {
            managedDeps = Collections.emptyList();
            deps = () -> Collections.emptyList();
            importedPlatforms = Collections.emptyList();
            quarkusVersion = null;
        } else {
            ArtifactDescriptorResult descriptor = MavenProjectBuildFile.describe(mvnResolver, projectPom);
            managedDeps = MavenProjectBuildFile.toArtifactCoords(descriptor.getManagedDependencies());
            deps = () -> MavenProjectBuildFile.toArtifactCoords(descriptor.getDependencies());
            importedPlatforms = MavenProjectBuildFile.collectPlatformDescriptors(managedDeps, log);
            quarkusVersion = MavenProjectBuildFile.getQuarkusVersion(managedDeps);
        }
        ExtensionCatalogResolver extensionCatalogResolver = catalogResolver = QuarkusProjectHelper.isRegistryClientEnabled() ? QuarkusProjectHelper.getCatalogResolver(mvnResolver, log) : ExtensionCatalogResolver.empty();
        if (catalogResolver.hasRegistries()) {
            try {
                if (!importedPlatforms.isEmpty()) {
                    extensionCatalog = catalogResolver.resolveExtensionCatalog(importedPlatforms);
                }
                extensionCatalog = quarkusVersion == null ? catalogResolver.resolveExtensionCatalog() : catalogResolver.resolveExtensionCatalog(quarkusVersion);
            }
            catch (RegistryResolutionException e) {
                throw new RuntimeException("Failed to resolve extension catalog", e);
            }
        } else {
            extensionCatalog = importedPlatforms.isEmpty() ? ToolsUtils.resolvePlatformDescriptorDirectly(null, null, quarkusVersion, mvnResolver, log) : ToolsUtils.mergePlatforms(importedPlatforms, mvnResolver);
        }
        MavenProjectBuildFile extensionManager = new MavenProjectBuildFile(projectDir, extensionCatalog, projectModel, deps, managedDeps, projectProps, projectPom == null ? null : mvnResolver);
        List<ResourceLoader> codestartResourceLoaders = CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(extensionCatalog).artifactResolver(mvnResolver).build();
        return QuarkusProject.of(projectDir, extensionCatalog, codestartResourceLoaders, log, extensionManager);
    }

    private static MavenArtifactResolver getMavenResolver(Path projectDir) {
        RegistriesConfig toolsConfig = QuarkusProjectHelper.toolsConfig();
        try {
            return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setArtifactTransferLogging(toolsConfig.isDebug())).setCurrentProject(projectDir.toAbsolutePath().toString())).setPreferPomsFromWorkspace(true)).build();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
        }
    }

    private static String getQuarkusVersion(List<ArtifactCoords> managedDeps) {
        for (ArtifactCoords a : managedDeps) {
            if (!a.getArtifactId().endsWith("quarkus-core") || !a.getGroupId().equals("io.quarkus")) continue;
            return a.getVersion();
        }
        return null;
    }

    private static List<ArtifactCoords> toArtifactCoords(List<Dependency> deps) {
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(deps.size());
        for (Dependency dep : deps) {
            Artifact a = dep.getArtifact();
            result.add(new ArtifactCoords(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion()));
        }
        return result;
    }

    private static ArtifactDescriptorResult describe(MavenArtifactResolver resolver, Artifact projectArtifact) {
        try {
            return resolver.resolveDescriptor(projectArtifact);
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve descriptor for " + projectArtifact, e);
        }
    }

    private static List<ArtifactCoords> collectPlatformDescriptors(List<ArtifactCoords> managedDeps, MessageWriter log) {
        if (managedDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(4);
        for (ArtifactCoords c : managedDeps) {
            if (!PlatformArtifacts.isCatalogArtifact((ArtifactCoords)c)) continue;
            result.add(c);
        }
        return result;
    }

    private static boolean isSameFile(Path p1, Path p2) {
        try {
            return Files.isSameFile(p1, p2);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compare " + p1 + " to " + p2, e);
        }
    }

    private MavenProjectBuildFile(Path projectDirPath, ExtensionCatalog extensionsCatalog, Model model, Supplier<List<ArtifactCoords>> projectDeps, List<ArtifactCoords> projectManagedDeps, Properties projectProps, MavenArtifactResolver resolver) {
        super(projectDirPath, extensionsCatalog);
        this.model = model;
        this.projectDepsSupplier = projectDeps;
        this.managedDependencies = projectManagedDeps;
        this.projectProps = projectProps;
        this.resolver = resolver;
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.MAVEN;
    }

    @Override
    protected boolean importBom(ArtifactCoords coords) {
        if (!"pom".equalsIgnoreCase(coords.getType())) {
            throw new IllegalArgumentException(coords + " is not a POM");
        }
        String depKey = MavenProjectBuildFile.depKey(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType());
        if (coords.getGroupId().equals(this.getProperty("quarkus.platform.group-id")) && coords.getVersion().equals(this.getProperty("quarkus.platform.version"))) {
            coords = new ArtifactCoords("${quarkus.platform.group-id}", coords.getArtifactId().equals(this.getProperty("quarkus.platform.artifact-id")) ? "${quarkus.platform.artifact-id}" : coords.getArtifactId(), "pom", "${quarkus.platform.version}");
        }
        org.apache.maven.model.Dependency d = new org.apache.maven.model.Dependency();
        d.setGroupId(coords.getGroupId());
        d.setArtifactId(coords.getArtifactId());
        d.setType(coords.getType());
        d.setScope("import");
        d.setVersion(coords.getVersion());
        DependencyManagement dependencyManagement = this.model().getDependencyManagement();
        if (dependencyManagement == null) {
            dependencyManagement = new DependencyManagement();
            this.model().setDependencyManagement(dependencyManagement);
        }
        if (dependencyManagement.getDependencies().stream().filter(t -> t.getScope().equals("import")).noneMatch(thisDep -> depKey.equals(this.resolveKey((org.apache.maven.model.Dependency)thisDep)))) {
            dependencyManagement.addDependency(d);
            if (!this.getManagedDependencies().contains(coords)) {
                this.getManagedDependencies().add(coords);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean addDependency(ArtifactCoords coords, boolean managed) {
        org.apache.maven.model.Dependency d = new org.apache.maven.model.Dependency();
        d.setGroupId(coords.getGroupId());
        d.setArtifactId(coords.getArtifactId());
        if (!managed) {
            d.setVersion(coords.getVersion());
        }
        if (coords.getClassifier() != null && !coords.getClassifier().isEmpty()) {
            d.setClassifier(coords.getClassifier());
        }
        d.setType(coords.getType());
        if ("pom".equalsIgnoreCase(coords.getType())) {
            d.setScope("import");
            DependencyManagement dependencyManagement = this.model().getDependencyManagement();
            if (dependencyManagement == null) {
                dependencyManagement = new DependencyManagement();
                this.model().setDependencyManagement(dependencyManagement);
            }
            if (dependencyManagement.getDependencies().stream().noneMatch(thisDep -> d.getManagementKey().equals(this.resolveKey((org.apache.maven.model.Dependency)thisDep)))) {
                dependencyManagement.addDependency(d);
                if (!this.getManagedDependencies().contains(coords)) {
                    this.getManagedDependencies().add(coords);
                }
                return true;
            }
        } else if (this.model().getDependencies().stream().noneMatch(thisDep -> d.getManagementKey().equals(thisDep.getManagementKey()))) {
            int index = this.getIndexToAddExtension();
            if (index >= 0) {
                this.model().getDependencies().add(index, d);
            } else {
                this.model().getDependencies().add(d);
            }
            if (!this.getDependencies().contains(coords)) {
                this.getDependencies().add(coords);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void removeDependency(ArtifactKey key) throws IOException {
        if (this.model() != null) {
            Iterator<ArtifactCoords> i = this.getDependencies().iterator();
            while (i.hasNext()) {
                ArtifactCoords a = i.next();
                if (!a.getKey().equals((Object)key)) continue;
                i.remove();
                break;
            }
            this.model().getDependencies().removeIf(d -> Objects.equals(Extensions.toKey(d), key));
        }
    }

    @Override
    protected List<ArtifactCoords> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = this.projectDepsSupplier.get();
            this.projectDepsSupplier = null;
        }
        return this.dependencies;
    }

    @Override
    public final Collection<ArtifactCoords> getInstalledPlatforms() throws IOException {
        if (this.importedPlatforms == null) {
            ArrayList<ArtifactCoords> tmp = new ArrayList<ArtifactCoords>();
            for (ArtifactCoords c : this.getManagedDependencies()) {
                if (!PlatformArtifacts.isCatalogArtifact((ArtifactCoords)c)) continue;
                tmp.add(PlatformArtifacts.getBomArtifactForCatalog((ArtifactCoords)c));
            }
            this.importedPlatforms = tmp;
        }
        return this.importedPlatforms;
    }

    protected List<ArtifactCoords> getManagedDependencies() {
        return this.managedDependencies;
    }

    @Override
    protected void writeToDisk() throws IOException {
        if (this.model == null) {
            return;
        }
        try (ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();){
            MojoUtils.write(this.model(), pomOutputStream);
            this.writeToProjectFile(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toByteArray());
        }
    }

    @Override
    protected String getProperty(String propertyName) {
        return this.projectProps.getProperty(propertyName);
    }

    @Override
    protected void refreshData() {
        Path projectPom = this.getProjectDirPath().resolve("pom.xml");
        if (!Files.exists(projectPom, new LinkOption[0])) {
            return;
        }
        try {
            this.model = ModelUtils.readModel((Path)projectPom);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + projectPom, e);
        }
        this.projectProps = this.model.getProperties();
        ArtifactDescriptorResult descriptor = MavenProjectBuildFile.describe(this.resolver(), (Artifact)new DefaultArtifact(ModelUtils.getGroupId((Model)this.model), this.model.getArtifactId(), "pom", ModelUtils.getVersion((Model)this.model)));
        this.managedDependencies = MavenProjectBuildFile.toArtifactCoords(descriptor.getManagedDependencies());
        this.projectDepsSupplier = () -> MavenProjectBuildFile.toArtifactCoords(descriptor.getDependencies());
        this.dependencies = null;
    }

    private MavenArtifactResolver resolver() {
        return this.resolver == null ? (this.resolver = MavenProjectBuildFile.getMavenResolver(this.getProjectDirPath())) : this.resolver;
    }

    private int getIndexToAddExtension() {
        List dependencies = this.model().getDependencies();
        for (int i = 0; i < dependencies.size(); ++i) {
            if (!"test".equals(((org.apache.maven.model.Dependency)dependencies.get(i)).getScope())) continue;
            return i;
        }
        return -1;
    }

    private Model model() {
        return this.model;
    }

    private String resolveKey(org.apache.maven.model.Dependency dependency) {
        String resolvedGroupId = this.toResolvedProperty(dependency.getGroupId());
        String resolvedArtifactId = this.toResolvedProperty(dependency.getArtifactId());
        String resolvedVersion = this.toResolvedProperty(dependency.getVersion());
        if (!(resolvedGroupId.equals(dependency.getGroupId()) && resolvedArtifactId.equals(dependency.getArtifactId()) && resolvedVersion.equals(dependency.getVersion()))) {
            return MavenProjectBuildFile.depKey(resolvedGroupId, resolvedArtifactId, dependency.getClassifier(), dependency.getType());
        }
        return dependency.getManagementKey();
    }

    private static String depKey(String groupId, String artifactId, String classifier, String type) {
        StringBuilder buf = new StringBuilder();
        buf.append(groupId).append(':').append(artifactId).append(':').append(type);
        if (classifier != null && !classifier.isEmpty()) {
            buf.append(':').append(classifier);
        }
        return buf.toString();
    }

    private String toResolvedProperty(String value) {
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        if (matcher.matches()) {
            String property = this.getProperty(matcher.group(1));
            return property == null ? value : property;
        }
        return value;
    }
}

