/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.reader;

import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.core.reader.CodestartFileReader;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

final class QuteCodestartFileReader
implements CodestartFileReader {
    private static final String FLAG = ".tpl.qute";
    public static final String INCLUDE_QUTE_FLAG = ".include.qute";

    QuteCodestartFileReader() {
    }

    @Override
    public boolean matches(String fileName) {
        return fileName.contains(FLAG) || fileName.contains(INCLUDE_QUTE_FLAG);
    }

    @Override
    public String cleanFileName(String fileName) {
        return fileName.replace(FLAG, "");
    }

    @Override
    public Optional<String> read(CodestartResource.Source source, String languageName, Map<String, Object> data) throws IOException {
        if (FilenameUtils.getName((String)source.path()).contains(INCLUDE_QUTE_FLAG)) {
            return Optional.empty();
        }
        return Optional.of(QuteCodestartFileReader.readQuteFile(source, languageName, data));
    }

    public static String readQuteFile(CodestartResource.Source source, String languageName, Map<String, Object> data) {
        String content = source.read();
        Engine engine = Engine.builder().addDefaults().addResultMapper((ResultMapper)new MissingValueMapper()).removeStandaloneLines(true).addLocator(id -> QuteCodestartFileReader.findIncludeTemplate(source, languageName, id).map(IncludeTemplateLocation::new)).build();
        try {
            return engine.parse(content).render(data);
        }
        catch (TemplateException e) {
            throw new CodestartException("Error while rendering template: " + source.absolutePath(), e);
        }
    }

    private static Optional<CodestartResource.Source> findIncludeTemplate(CodestartResource.Source source, String languageName, String name) {
        String includeFileName = name + INCLUDE_QUTE_FLAG;
        Optional<CodestartResource.Source> languageIncludeSource = source.getCodestartResource().getSource(languageName, includeFileName);
        if (languageIncludeSource.isPresent()) {
            return languageIncludeSource;
        }
        Optional<CodestartResource.Source> baseIncludeSource = source.getCodestartResource().getSource("base", includeFileName);
        if (baseIncludeSource.isPresent()) {
            return baseIncludeSource;
        }
        return Optional.empty();
    }

    static class MissingValueMapper
    implements ResultMapper {
        MissingValueMapper() {
        }

        public boolean appliesTo(TemplateNode.Origin origin, Object result) {
            return Results.Result.NOT_FOUND.equals(result);
        }

        public String map(Object result, Expression expression) {
            throw new TemplateException("Missing required data: {" + expression.toOriginalString() + "}");
        }
    }

    private static class IncludeTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final CodestartResource.Source source;

        public IncludeTemplateLocation(CodestartResource.Source source) {
            this.source = source;
        }

        public Reader read() {
            return new StringReader(this.source.read());
        }

        public Optional<Variant> getVariant() {
            return Optional.empty();
        }
    }
}

