/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import io.quarkus.deployment.dev.devservices.ContainerInfo;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ContainerUtil {
    private static final int CONTAINER_SHORT_ID_LENGTH = 12;

    public static RunningContainer toRunningContainer(InspectContainerResponse inspectContainer) {
        return new RunningContainer(ContainerUtil.toContainerInfo(inspectContainer), ContainerUtil.getContainerEnv(inspectContainer));
    }

    public static ContainerInfo toContainerInfo(InspectContainerResponse inspectContainer) {
        String[] names = (String[])inspectContainer.getNetworkSettings().getNetworks().values().stream().flatMap(c -> c.getAliases() == null ? Stream.of(new String[0]) : c.getAliases().stream()).toArray(String[]::new);
        return new ContainerInfo(inspectContainer.getId(), names, inspectContainer.getConfig().getImage(), inspectContainer.getState().getStatus(), ContainerUtil.getNetworks(inspectContainer), inspectContainer.getConfig().getLabels(), ContainerUtil.getExposedPorts(inspectContainer));
    }

    private static Map<String, String[]> getNetworks(InspectContainerResponse container) {
        NetworkSettings networkSettings = container.getNetworkSettings();
        if (networkSettings == null) {
            return null;
        }
        return ContainerUtil.getNetworks(networkSettings.getNetworks());
    }

    public static Map<String, String[]> getNetworks(Map<String, ContainerNetwork> networkSettings) {
        if (networkSettings == null) {
            return null;
        }
        return networkSettings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List aliases = ((ContainerNetwork)e.getValue()).getAliases();
            return aliases == null ? new String[]{} : aliases.toArray(new String[0]);
        }));
    }

    private static ContainerInfo.ContainerPort[] getExposedPorts(InspectContainerResponse inspectContainer) {
        return (ContainerInfo.ContainerPort[])inspectContainer.getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(e -> e.getValue() != null).flatMap(e -> Arrays.stream((Ports.Binding[])e.getValue()).map(b -> new ContainerInfo.ContainerPort(b.getHostIp(), Integer.valueOf(((ExposedPort)e.getKey()).getPort()), Integer.valueOf(Integer.parseInt(b.getHostPortSpec())), ((ExposedPort)e.getKey()).getProtocol().toString()))).toArray(ContainerInfo.ContainerPort[]::new);
    }

    public static Map<String, String> getContainerEnv(InspectContainerResponse inspectContainer) {
        String[] env = inspectContainer.getConfig().getEnv();
        if (env == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(env).map(e -> e.split("=", 2)).collect(Collectors.toMap(e -> e[0], e -> ((String[])e).length > 1 ? e[1] : ""));
    }

    public static Map<String, String> getEnvVarConfig(List<? extends Supplier<InspectContainerResponse>> instances, Function<InspectContainerResponse, Map<String, String>> envVarMappingHint) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Supplier<InspectContainerResponse> supplier : instances) {
            configs.putAll(ContainerUtil.getEnvVarConfig(supplier, envVarMappingHint));
        }
        return configs;
    }

    public static Map<String, String> getEnvVarConfig(Supplier<InspectContainerResponse> containerInfoSupplier, Function<InspectContainerResponse, Map<String, String>> envVarMappingHint) {
        HashMap<String, String> configs = new HashMap<String, String>();
        InspectContainerResponse containerInfo = containerInfoSupplier.get();
        Map<String, String> mappings = envVarMappingHint.apply(containerInfo);
        if (mappings != null && !mappings.isEmpty()) {
            Map<String, String> containerEnv = ContainerUtil.getContainerEnv(containerInfo);
            mappings.forEach((k, v) -> {
                String value = (String)containerEnv.get(k);
                if (value != null) {
                    configs.put((String)v, value);
                }
            });
        }
        return configs;
    }

    public static Map<String, String> getPortConfig(List<? extends Supplier<InspectContainerResponse>> instances, Function<InspectContainerResponse, Map<Integer, String>> envVarMappingHint) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Supplier<InspectContainerResponse> supplier : instances) {
            configs.putAll(ContainerUtil.getPortConfig(supplier, envVarMappingHint));
        }
        return configs;
    }

    public static Map<String, String> getPortConfig(Supplier<InspectContainerResponse> containerResponseSupplier, Function<InspectContainerResponse, Map<Integer, String>> envVarMappingHint) {
        HashMap<String, String> configs = new HashMap<String, String>();
        InspectContainerResponse containerInfo = containerResponseSupplier.get();
        Map<Integer, String> mappings = envVarMappingHint.apply(containerInfo);
        if (mappings != null && !mappings.isEmpty()) {
            mappings.forEach((containerPort, envVar) -> {
                for (ContainerInfo.ContainerPort exposedPort : ContainerUtil.getExposedPorts(containerInfo)) {
                    if (!Objects.equals(exposedPort.privatePort(), containerPort)) continue;
                    configs.put((String)envVar, String.valueOf(exposedPort.publicPort()));
                    break;
                }
            });
        }
        return configs;
    }

    public static String getShortId(String id) {
        return id.length() > 12 ? id.substring(0, 12) : id;
    }
}

