/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;

public class ProfileManager {
    public static final String QUARKUS_PROFILE_ENV = "QUARKUS_PROFILE";
    public static final String QUARKUS_PROFILE_PROP = "quarkus.profile";
    public static final String QUARKUS_TEST_PROFILE_PROP = "quarkus.test.profile";
    private static final String BACKWARD_COMPATIBLE_QUARKUS_PROFILE_PROP = "quarkus-profile";
    private static volatile LaunchMode launchMode = LaunchMode.NORMAL;
    private static String runtimeDefaultProfile = null;

    public static void setLaunchMode(LaunchMode mode) {
        launchMode = mode;
    }

    public static LaunchMode getLaunchMode() {
        return launchMode;
    }

    public static void setRuntimeDefaultProfile(String profile) {
        runtimeDefaultProfile = profile;
    }

    public static String getActiveProfile() {
        if (launchMode == LaunchMode.TEST) {
            String profile = System.getProperty(QUARKUS_TEST_PROFILE_PROP);
            if (profile != null) {
                return profile;
            }
            return launchMode.getDefaultProfile();
        }
        String profile = System.getProperty(QUARKUS_PROFILE_PROP);
        if (profile != null) {
            return profile;
        }
        profile = System.getProperty(BACKWARD_COMPATIBLE_QUARKUS_PROFILE_PROP);
        if (profile != null) {
            return profile;
        }
        profile = System.getenv(QUARKUS_PROFILE_ENV);
        if (profile != null) {
            return profile;
        }
        profile = runtimeDefaultProfile;
        if (profile != null) {
            return profile;
        }
        return launchMode.getDefaultProfile();
    }
}

