/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalBootstrapConfigSourceProviderBuildItem;
import io.quarkus.deployment.builditem.AdditionalStaticInitConfigSourceProviderBuildItem;
import io.quarkus.deployment.builditem.ConfigMappingBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigSourceFactoryBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigSourceProviderBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.StaticInitSafe;
import io.quarkus.runtime.configuration.ConfigRecorder;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.PropertiesLocationConfigSourceFactory;
import io.smallrye.config.SmallRyeConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class ConfigGenerationBuildStep {
    @BuildStep
    void deprecatedStaticInitBuildItem(List<AdditionalStaticInitConfigSourceProviderBuildItem> additionalStaticInitConfigSourceProviders, BuildProducer<StaticInitConfigSourceProviderBuildItem> staticInitConfigSourceProviderBuildItem) {
        for (AdditionalStaticInitConfigSourceProviderBuildItem item : additionalStaticInitConfigSourceProviders) {
            staticInitConfigSourceProviderBuildItem.produce(new StaticInitConfigSourceProviderBuildItem(item.getProviderClassName()));
        }
    }

    @BuildStep
    void staticInitSources(BuildProducer<StaticInitConfigSourceProviderBuildItem> staticInitConfigSourceProviderBuildItem, BuildProducer<StaticInitConfigSourceFactoryBuildItem> staticInitConfigSourceFactoryBuildItem) {
        staticInitConfigSourceFactoryBuildItem.produce(new StaticInitConfigSourceFactoryBuildItem(PropertiesLocationConfigSourceFactory.class.getName()));
    }

    @BuildStep
    GeneratedResourceBuildItem runtimeDefaultsConfig(List<RunTimeConfigurationDefaultBuildItem> runTimeDefaults, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceBuildItemBuildProducer) throws IOException {
        Properties p = new Properties();
        for (RunTimeConfigurationDefaultBuildItem e : runTimeDefaults) {
            p.setProperty(e.getKey(), e.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        p.store(out, null);
        nativeImageResourceBuildItemBuildProducer.produce(new NativeImageResourceBuildItem("quarkus-runtime-config-defaults.properties"));
        return new GeneratedResourceBuildItem("quarkus-runtime-config-defaults.properties", out.toByteArray());
    }

    @BuildStep
    void generateConfigClass(ConfigurationBuildItem configItem, List<ConfigurationTypeBuildItem> typeItems, LaunchModeBuildItem launchModeBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, LiveReloadBuildItem liveReloadBuildItem, List<AdditionalBootstrapConfigSourceProviderBuildItem> additionalBootstrapConfigSourceProviders, List<StaticInitConfigSourceProviderBuildItem> staticInitConfigSourceProviders, List<StaticInitConfigSourceFactoryBuildItem> staticInitConfigSourceFactories, List<ConfigMappingBuildItem> configMappings, List<StaticInitConfigBuilderBuildItem> staticInitConfigBuilders, List<RunTimeConfigBuilderBuildItem> runTimeConfigBuilders) throws IOException {
        if (liveReloadBuildItem.isLiveReload()) {
            return;
        }
        Set<String> discoveredConfigSources = ConfigGenerationBuildStep.discoverService(ConfigSource.class, reflectiveClass);
        Set<String> discoveredConfigSourceProviders = ConfigGenerationBuildStep.discoverService(ConfigSourceProvider.class, reflectiveClass);
        Set<String> discoveredConfigSourceFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceFactory.class, reflectiveClass);
        HashSet<String> staticConfigSourceProviders = new HashSet<String>();
        staticConfigSourceProviders.addAll(ConfigGenerationBuildStep.staticSafeServices(discoveredConfigSourceProviders));
        staticConfigSourceProviders.addAll(staticInitConfigSourceProviders.stream().map(StaticInitConfigSourceProviderBuildItem::getProviderClassName).collect(Collectors.toSet()));
        HashSet<String> staticConfigSourceFactories = new HashSet<String>();
        staticConfigSourceFactories.addAll(ConfigGenerationBuildStep.staticSafeServices(discoveredConfigSourceFactories));
        staticConfigSourceFactories.addAll(staticInitConfigSourceFactories.stream().map(StaticInitConfigSourceFactoryBuildItem::getFactoryClassName).collect(Collectors.toSet()));
        RunTimeConfigurationGenerator.GenerateOperation.builder().setBuildTimeReadResult(configItem.getReadResult()).setClassOutput(new GeneratedClassGizmoAdaptor(generatedClass, false)).setLaunchMode(launchModeBuildItem.getLaunchMode()).setLiveReloadPossible(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT || launchModeBuildItem.isAuxiliaryApplication()).setAdditionalTypes(typeItems.stream().map(ConfigurationTypeBuildItem::getValueType).collect(Collectors.toList())).setAdditionalBootstrapConfigSourceProviders(this.getAdditionalBootstrapConfigSourceProviders(additionalBootstrapConfigSourceProviders)).setStaticConfigSources(ConfigGenerationBuildStep.staticSafeServices(discoveredConfigSources)).setStaticConfigSourceProviders(staticConfigSourceProviders).setStaticConfigSourceFactories(staticConfigSourceFactories).setStaticConfigMappings(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings)).setStaticConfigBuilders(staticInitConfigBuilders.stream().map(StaticInitConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet())).setRuntimeConfigSources(discoveredConfigSources).setRuntimeConfigSourceProviders(discoveredConfigSourceProviders).setRuntimeConfigSourceFactories(discoveredConfigSourceFactories).setRuntimeConfigMappings(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings)).setRuntimeConfigBuilders(runTimeConfigBuilders.stream().map(RunTimeConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet())).build().run();
    }

    private List<String> getAdditionalBootstrapConfigSourceProviders(List<AdditionalBootstrapConfigSourceProviderBuildItem> additionalBootstrapConfigSourceProviders) {
        if (additionalBootstrapConfigSourceProviders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(additionalBootstrapConfigSourceProviders.size());
        for (AdditionalBootstrapConfigSourceProviderBuildItem provider : additionalBootstrapConfigSourceProviders) {
            result.add(provider.getProviderClassName());
        }
        return result;
    }

    @BuildStep
    public void suppressNonRuntimeConfigChanged(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChanged) {
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.profile"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.uuid"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.default-locale"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.locales"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void checkForBuildTimeConfigChange(ConfigRecorder recorder, ConfigurationBuildItem configItem, LoggingSetupBuildItem loggingSetupBuildItem, List<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChangedWarningItems) {
        BuildTimeConfigurationReader.ReadResult readResult = configItem.getReadResult();
        Config config = ConfigProvider.getConfig();
        HashSet<String> excludedConfigKeys = new HashSet<String>(suppressNonRuntimeConfigChangedWarningItems.size());
        for (SuppressNonRuntimeConfigChangedWarningBuildItem item : suppressNonRuntimeConfigChangedWarningItems) {
            excludedConfigKeys.add(item.getConfigKey());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (RootDefinition root : readResult.getAllRoots()) {
            if (root.getConfigPhase() != ConfigPhase.BUILD_AND_RUN_TIME_FIXED && root.getConfigPhase() != ConfigPhase.BUILD_TIME) continue;
            Iterable<ClassDefinition.ClassMember> members = root.getMembers();
            this.handleMembers(config, values, members, root.getName() + ".", excludedConfigKeys);
        }
        recorder.handleConfigChange(values);
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public void setupConfigOverride(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RuntimeOverrideConfigSource.GENERATED_CLASS_NAME).build();){
            clazz.getFieldCreator("CONFIG", Map.class).setModifiers(73);
        }
    }

    @BuildStep
    public void watchConfigFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        ArrayList<String> configWatchedFiles = new ArrayList<String>();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        String userDir = System.getProperty("user.dir");
        configWatchedFiles.add("application.properties");
        configWatchedFiles.add("META-INF/microprofile-config.properties");
        configWatchedFiles.add(Paths.get(userDir, ".env").toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", "application.properties").toAbsolutePath().toString());
        String profile = ProfileManager.getActiveProfile();
        configWatchedFiles.add(String.format("application-%s.properties", profile));
        configWatchedFiles.add(String.format("META-INF/microprofile-config-%s.properties", profile));
        configWatchedFiles.add(Paths.get(userDir, String.format(".env-%s", profile)).toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.properties", profile)).toAbsolutePath().toString());
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(locations -> {
            for (URI location : locations) {
                Path path = location.getScheme() != null ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                configWatchedFiles.add(location.toString());
                configWatchedFiles.add(this.appendProfileToFilename(location.toString(), profile));
            }
        });
        for (String configWatchedFile : configWatchedFiles) {
            watchedFiles.produce(new HotDeploymentWatchedFileBuildItem(configWatchedFile));
        }
    }

    private String appendProfileToFilename(String path, String activeProfile) {
        String pathWithoutExtension = FilenameUtils.removeExtension((String)path);
        return String.format("%s-%s.%s", pathWithoutExtension, activeProfile, FilenameUtils.getExtension((String)path));
    }

    private void handleMembers(Config config, Map<String, String> values, Iterable<ClassDefinition.ClassMember> members, String prefix, Set<String> excludedConfigKeys) {
        for (ClassDefinition.ClassMember member : members) {
            if (member instanceof ClassDefinition.ItemMember) {
                ClassDefinition.ItemMember itemMember = (ClassDefinition.ItemMember)member;
                String propertyName = prefix + member.getPropertyName();
                if (excludedConfigKeys.contains(propertyName)) continue;
                Optional val = config.getOptionalValue(propertyName, String.class);
                if (val.isPresent()) {
                    values.put(propertyName, (String)val.get());
                    continue;
                }
                values.put(propertyName, itemMember.getDefaultValue());
                continue;
            }
            if (!(member instanceof ClassDefinition.GroupMember)) continue;
            this.handleMembers(config, values, ((ClassDefinition.GroupMember)member).getGroupDefinition().getMembers(), prefix + member.getDescriptor().getName() + ".", excludedConfigKeys);
        }
    }

    private static Set<String> discoverService(Class<?> serviceClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<String> services = new HashSet<String>();
        for (String service : ServiceUtil.classNamesNamedIn(classLoader, "META-INF/services/" + serviceClass.getName())) {
            services.add(service);
            reflectiveClass.produce(new ReflectiveClassBuildItem(true, false, false, service));
        }
        return services;
    }

    private static Set<String> staticSafeServices(Set<String> services) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        HashSet<String> staticSafe = new HashSet<String>();
        for (String service : services) {
            try {
                Class<?> serviceClass = classloader.loadClass(service);
                if (!serviceClass.isAnnotationPresent(StaticInitSafe.class)) continue;
                staticSafe.add(service);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return staticSafe;
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> staticSafeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().filter(ConfigMappingBuildItem::isStaticInitSafe).map(configMapping -> ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(configMapping.getConfigClass(), (String)configMapping.getPrefix())).collect(Collectors.toSet());
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> runtimeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().map(configMapping -> ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(configMapping.getConfigClass(), (String)configMapping.getPrefix())).collect(Collectors.toSet());
    }
}

