/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassFinalFieldsWritablePredicateBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.VoidType;
import org.jboss.logging.Logger;

public class ReflectiveHierarchyStep {
    private static final Logger log = Logger.getLogger(ReflectiveHierarchyStep.class);

    @BuildStep
    public ReflectiveHierarchyIgnoreWarningBuildItem ignoreJavaClassWarnings() {
        return new ReflectiveHierarchyIgnoreWarningBuildItem(ReflectiveHierarchyBuildItem.IgnoreWhiteListedPredicate.INSTANCE);
    }

    @BuildStep
    public void build(CombinedIndexBuildItem combinedIndexBuildItem, List<ReflectiveHierarchyBuildItem> hierarchy, List<ReflectiveHierarchyIgnoreWarningBuildItem> ignored, List<ReflectiveClassFinalFieldsWritablePredicateBuildItem> finalFieldsWritablePredicates, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws Exception {
        HashSet<DotName> processedReflectiveHierarchies = new HashSet<DotName>();
        TreeSet<DotName> unindexedClasses = new TreeSet<DotName>();
        Predicate finalFieldsWritable = c -> false;
        if (!finalFieldsWritablePredicates.isEmpty()) {
            finalFieldsWritable = finalFieldsWritablePredicates.stream().map(ReflectiveClassFinalFieldsWritablePredicateBuildItem::getPredicate).reduce(c -> false, Predicate::or);
        }
        for (ReflectiveHierarchyBuildItem i : hierarchy) {
            this.addReflectiveHierarchy(combinedIndexBuildItem, i, i.getType(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
        }
        this.removeIgnored(unindexedClasses, ignored);
        if (!unindexedClasses.isEmpty()) {
            String unindexedClassesWarn = unindexedClasses.stream().map(d -> "\t- " + d).collect(Collectors.joining("\n"));
            log.warnf("Unable to properly register the hierarchy of the following classes for reflection as they are not in the Jandex index:%n%s%nConsider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.\");.", (Object)unindexedClassesWarn);
        }
    }

    private void removeIgnored(Set<DotName> unindexedClasses, List<ReflectiveHierarchyIgnoreWarningBuildItem> ignored) {
        if (ignored.isEmpty()) {
            return;
        }
        HashSet<DotName> ignoredWarnings = new HashSet<DotName>();
        Predicate finalPredicate = ignored.stream().map(ReflectiveHierarchyIgnoreWarningBuildItem::getPredicate).reduce(x -> false, Predicate::or);
        for (DotName unindexedClass : unindexedClasses) {
            if (!finalPredicate.test(unindexedClass)) continue;
            ignoredWarnings.add(unindexedClass);
        }
        unindexedClasses.removeAll(ignoredWarnings);
    }

    private void addReflectiveHierarchy(CombinedIndexBuildItem combinedIndexBuildItem, ReflectiveHierarchyBuildItem reflectiveHierarchyBuildItem, Type type, Set<DotName> processedReflectiveHierarchies, Set<DotName> unindexedClasses, Predicate<ClassInfo> finalFieldsWritable, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        block7: {
            block8: {
                block6: {
                    if (type instanceof VoidType || type instanceof PrimitiveType || type instanceof UnresolvedTypeVariable) {
                        return;
                    }
                    if (!(type instanceof ClassType)) break block6;
                    if (this.skipClass(type.name(), reflectiveHierarchyBuildItem.getIgnorePredicate(), processedReflectiveHierarchies)) {
                        return;
                    }
                    this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, type.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                    for (ClassInfo subclass : combinedIndexBuildItem.getIndex().getAllKnownSubclasses(type.name())) {
                        this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, subclass.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                    }
                    for (ClassInfo subclass : combinedIndexBuildItem.getIndex().getAllKnownImplementors(type.name())) {
                        this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, subclass.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                    }
                    break block7;
                }
                if (!(type instanceof ArrayType)) break block8;
                this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, type.asArrayType().component(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                break block7;
            }
            if (!(type instanceof ParameterizedType)) break block7;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!reflectiveHierarchyBuildItem.getIgnorePredicate().test(parameterizedType.name())) {
                this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, parameterizedType.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            }
            for (Type typeArgument : parameterizedType.arguments()) {
                this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, typeArgument, processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            }
        }
    }

    private void addClassTypeHierarchy(CombinedIndexBuildItem combinedIndexBuildItem, ReflectiveHierarchyBuildItem reflectiveHierarchyBuildItem, DotName name, Set<DotName> processedReflectiveHierarchies, Set<DotName> unindexedClasses, Predicate<ClassInfo> finalFieldsWritable, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (this.skipClass(name, reflectiveHierarchyBuildItem.getIgnorePredicate(), processedReflectiveHierarchies)) {
            return;
        }
        processedReflectiveHierarchies.add(name);
        ClassInfo info = (reflectiveHierarchyBuildItem.getIndex() != null ? reflectiveHierarchyBuildItem.getIndex() : combinedIndexBuildItem.getIndex()).getClassByName(name);
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(name.toString()).methods(true).fields(true).finalFieldsWritable(this.doFinalFieldsNeedToBeWritable(info, finalFieldsWritable)).build());
        if (info == null) {
            unindexedClasses.add(name);
        } else {
            this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, info.superName(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            for (FieldInfo field : info.fields()) {
                if (Modifier.isStatic(field.flags()) || field.name().startsWith("this$") || field.name().startsWith("val$")) continue;
                this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, field.type(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            }
            for (MethodInfo method : info.methods()) {
                if (method.parameters().size() > 0 || Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID) continue;
                this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, method.returnType(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            }
        }
    }

    private boolean skipClass(DotName name, Predicate<DotName> ignorePredicate, Set<DotName> processedReflectiveHierarchies) {
        return ignorePredicate.test(name) || processedReflectiveHierarchies.contains(name);
    }

    private boolean doFinalFieldsNeedToBeWritable(ClassInfo classInfo, Predicate<ClassInfo> finalFieldsWritable) {
        if (classInfo == null) {
            return false;
        }
        return finalFieldsWritable.test(classInfo);
    }
}

