/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.runtime.configuration.NameIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import org.wildfly.common.Assert;

public final class ConfigPatternMap<T>
implements Iterable<T> {
    public static final String WILD_CARD = "{*}";
    private T matched;
    private final TreeMap<String, ConfigPatternMap<T>> children = new TreeMap();

    public T match(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.match(new NameIterator(name, false));
    }

    public T match(NameIterator nameIterator) {
        Assert.checkNotNullParam((String)"nameIterator", (Object)nameIterator);
        if (!nameIterator.hasNext()) {
            return this.matched;
        }
        nameIterator.next();
        try {
            T t = this.matchLeaf(nameIterator);
            return t;
        }
        finally {
            nameIterator.previous();
        }
    }

    T matchLeaf(NameIterator nameIterator) {
        ConfigPatternMap<T> next = this.children.get(nameIterator.getPreviousSegment());
        if (next != null) {
            return next.match(nameIterator);
        }
        next = this.children.get(WILD_CARD);
        if (next != null) {
            return next.match(nameIterator);
        }
        return null;
    }

    public boolean addPattern(String pattern, T onMatch) {
        Assert.checkNotNullParam((String)"pattern", (Object)pattern);
        Assert.checkNotNullParam((String)"onMatch", onMatch);
        return this.addPattern(new NameIterator(pattern, false), onMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addPattern(NameIterator nameIterator, T onMatch) {
        if (!nameIterator.hasNext()) {
            if (this.matched != null) {
                return Objects.equals(onMatch, this.matched);
            }
            this.matched = onMatch;
            return true;
        }
        nameIterator.next();
        try {
            boolean bl = this.children.computeIfAbsent(ConfigPatternMap.getKey(nameIterator), s -> new ConfigPatternMap()).addPattern(nameIterator, onMatch);
            return bl;
        }
        finally {
            nameIterator.previous();
        }
    }

    private static String getKey(NameIterator nameIterator) {
        String str = nameIterator.getPreviousSegment();
        if (str.equals(WILD_CARD)) {
            return WILD_CARD;
        }
        return str;
    }

    public T getMatched() {
        return this.matched;
    }

    public void setMatched(T matched) {
        this.matched = matched;
    }

    public Iterable<String> childNames() {
        return () -> this.children.keySet().iterator();
    }

    public ConfigPatternMap<T> getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public PatternIterator<T> iterator() {
        return new PatternIterator<T>(this.children, this);
    }

    public void addChild(String childName, ConfigPatternMap<T> child) {
        this.children.put(childName, child);
    }

    public static class PatternIterator<T>
    implements Iterator<T> {
        ConfigPatternMap<T> current;
        ConfigPatternMap<T> next;
        PatternIterator<T> currentItr;
        Iterator<ConfigPatternMap<T>> childMaps;

        PatternIterator(TreeMap<String, ConfigPatternMap<T>> children, ConfigPatternMap<T> initial) {
            this.next = initial.getMatched() == null ? null : initial;
            this.childMaps = children.values().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.currentItr == null) {
                    if (!this.childMaps.hasNext()) {
                        return false;
                    }
                    ConfigPatternMap<T> nextChildMap = this.childMaps.next();
                    this.currentItr = nextChildMap.iterator();
                }
                if (this.currentItr.hasNext()) {
                    this.next = this.currentItr.nextPattern();
                    if (this.next.getMatched() != null) continue;
                    this.next = null;
                    continue;
                }
                this.currentItr = null;
            }
            return true;
        }

        @Override
        public T next() {
            return this.nextPattern().getMatched();
        }

        ConfigPatternMap<T> nextPattern() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                this.current = this.next;
                ConfigPatternMap<T> configPatternMap = this.current;
                return configPatternMap;
            }
            finally {
                this.next = null;
            }
        }

        public T current() {
            return this.currentPatternMap().getMatched();
        }

        public ConfigPatternMap<T> currentPatternMap() {
            ConfigPatternMap<T> current = this.current;
            if (current == null) {
                throw new NoSuchElementException();
            }
            return current;
        }
    }
}

