/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateOutputBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateSystemPropertyBuildItem;
import io.quarkus.runtime.SubstrateRuntimePropertiesRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;

public class SubstrateSystemPropertiesBuildStep {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SubstrateOutputBuildItem writeNativeProps(ArchiveRootBuildItem root, List<SubstrateSystemPropertyBuildItem> props, SubstrateRuntimePropertiesRecorder recorder) throws Exception {
        Properties properties = new Properties();
        for (SubstrateSystemPropertyBuildItem i : props) {
            recorder.setInStaticInit(i.getKey(), i.getValue());
            if (!properties.containsKey(i.getKey())) {
                properties.put(i.getKey(), i.getValue());
                continue;
            }
            if (properties.get(i.getKey()).equals(i.getValue())) continue;
            throw new RuntimeException("Duplicate native image system property under " + i.getKey() + " conflicting values of " + i.getValue() + " and " + properties.get(i.getKey()));
        }
        try (FileOutputStream os = new FileOutputStream(new File(root.getArchiveRoot().toFile(), "native-image.properties"));
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            properties.store(osw, "Generated properties (do not edit)");
        }
        return new SubstrateOutputBuildItem();
    }
}

