/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.QuarkusConfig;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.ClassOutputBuildItem;
import io.quarkus.deployment.builditem.ExtensionClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusAugmentor {
    private static final Logger log = Logger.getLogger(QuarkusAugmentor.class);
    private final ClassOutput output;
    private final ClassLoader classLoader;
    private final Path root;
    private final Set<Class<? extends BuildItem>> finalResults;
    private final List<Consumer<BuildChainBuilder>> buildChainCustomizers;
    private final LaunchMode launchMode;
    private final List<Path> additionalApplicationArchives;
    private final Collection<Path> excludedFromIndexing;
    private final LiveReloadBuildItem liveReloadBuildItem;
    private final Properties buildSystemProperties;

    QuarkusAugmentor(Builder builder) {
        this.output = builder.output;
        this.classLoader = builder.classLoader;
        this.root = builder.root;
        this.finalResults = new HashSet<Class<? extends BuildItem>>(builder.finalResults);
        this.buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(builder.buildChainCustomizers);
        this.launchMode = builder.launchMode;
        this.additionalApplicationArchives = new ArrayList<Path>(builder.additionalApplicationArchives);
        this.excludedFromIndexing = builder.excludedFromIndexing;
        this.liveReloadBuildItem = builder.liveReloadState;
        this.buildSystemProperties = builder.buildSystemProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult run() throws Exception {
        long time = System.currentTimeMillis();
        log.info((Object)"Beginning quarkus augmentation");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        FileSystem rootFs = null;
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            BuildChainBuilder chainBuilder = BuildChain.builder();
            if (this.buildSystemProperties != null) {
                ExtensionLoader.loadStepsFrom(this.classLoader, this.buildSystemProperties, this.launchMode).accept(chainBuilder);
            } else {
                ExtensionLoader.loadStepsFrom(this.classLoader, this.launchMode).accept(chainBuilder);
            }
            chainBuilder.loadProviders(this.classLoader);
            chainBuilder.addInitial(QuarkusConfig.class).addInitial(ArchiveRootBuildItem.class).addInitial(ShutdownContextBuildItem.class).addInitial(ClassOutputBuildItem.class).addInitial(LaunchModeBuildItem.class).addInitial(LiveReloadBuildItem.class).addInitial(AdditionalApplicationArchiveBuildItem.class).addInitial(ExtensionClassLoaderBuildItem.class);
            for (Class<? extends BuildItem> clazz : this.finalResults) {
                chainBuilder.addFinal(clazz);
            }
            chainBuilder.addFinal(GeneratedClassBuildItem.class).addFinal(GeneratedResourceBuildItem.class);
            for (Consumer consumer : this.buildChainCustomizers) {
                consumer.accept(chainBuilder);
            }
            BuildChain chain = chainBuilder.build();
            if (!Files.isDirectory(this.root, new LinkOption[0])) {
                rootFs = FileSystems.newFileSystem(this.root, null);
            }
            BuildExecutionBuilder buildExecutionBuilder = chain.createExecutionBuilder("main").produce((BuildItem)QuarkusConfig.INSTANCE).produce((BuildItem)this.liveReloadBuildItem).produce((BuildItem)new ArchiveRootBuildItem(this.root, rootFs == null ? this.root : rootFs.getPath("/", new String[0]), this.excludedFromIndexing)).produce((BuildItem)new ClassOutputBuildItem(this.output)).produce((BuildItem)new ShutdownContextBuildItem()).produce((BuildItem)new LaunchModeBuildItem(this.launchMode)).produce((BuildItem)new ExtensionClassLoaderBuildItem(this.classLoader));
            for (Path i : this.additionalApplicationArchives) {
                buildExecutionBuilder.produce((BuildItem)new AdditionalApplicationArchiveBuildItem(i));
            }
            BuildResult buildResult = buildExecutionBuilder.execute();
            for (MultiBuildItem i : buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
                this.output.writeClass(i.isApplicationClass(), i.getName(), i.getClassData());
            }
            for (MultiBuildItem i : buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                this.output.writeResource(i.getName(), i.getClassData());
            }
            log.info((Object)("Quarkus augmentation completed in " + (System.currentTimeMillis() - time) + "ms"));
            BuildResult buildResult2 = buildResult;
            return buildResult2;
        }
        finally {
            if (rootFs != null) {
                try {
                    rootFs.close();
                }
                catch (Exception exception) {}
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        List<Path> additionalApplicationArchives = new ArrayList<Path>();
        Collection<Path> excludedFromIndexing = Collections.emptySet();
        ClassOutput output;
        ClassLoader classLoader;
        Path root;
        Set<Class<? extends BuildItem>> finalResults = new HashSet<Class<? extends BuildItem>>();
        private final List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
        LaunchMode launchMode = LaunchMode.NORMAL;
        LiveReloadBuildItem liveReloadState = new LiveReloadBuildItem();
        Properties buildSystemProperties;

        public Builder addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
            this.buildChainCustomizers.add(customizer);
            return this;
        }

        public List<Path> getAdditionalApplicationArchives() {
            return this.additionalApplicationArchives;
        }

        public Builder addAdditionalApplicationArchive(Path archive) {
            this.additionalApplicationArchives.add(archive);
            return this;
        }

        public Builder excludeFromIndexing(Collection<Path> excludedFromIndexing) {
            this.excludedFromIndexing = excludedFromIndexing;
            return this;
        }

        public ClassOutput getOutput() {
            return this.output;
        }

        public Builder setOutput(ClassOutput output) {
            this.output = output;
            return this;
        }

        public LaunchMode getLaunchMode() {
            return this.launchMode;
        }

        public Builder setLaunchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Path getRoot() {
            return this.root;
        }

        public <T extends BuildItem> Builder addFinal(Class<T> clazz) {
            this.finalResults.add(clazz);
            return this;
        }

        public Builder setRoot(Path root) {
            this.root = root;
            return this;
        }

        public Properties getBuildSystemProperties() {
            return this.buildSystemProperties;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public QuarkusAugmentor build() {
            return new QuarkusAugmentor(this);
        }

        public LiveReloadBuildItem getLiveReloadState() {
            return this.liveReloadState;
        }

        public Builder setLiveReloadState(LiveReloadBuildItem liveReloadState) {
            this.liveReloadState = liveReloadState;
            return this;
        }
    }
}

