/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public class DependencyUtils {
    public static ArtifactKey getKey(Artifact artifact) {
        return ArtifactKey.of((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier(), (String)artifact.getExtension());
    }

    public static ArtifactCoords getCoords(Artifact artifact) {
        return new GACTV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
    }

    public static Map<ArtifactKey, Dependency> toMap(List<Dependency> deps) {
        HashMap<ArtifactKey, Dependency> map = new HashMap<ArtifactKey, Dependency>(deps.size());
        for (int i = 0; i < deps.size(); ++i) {
            Dependency dep = deps.get(i);
            map.put(DependencyUtils.getKey(dep.getArtifact()), dep);
        }
        return map;
    }

    public static void putAll(Map<ArtifactKey, Dependency> map, List<Dependency> deps) {
        for (int i = 0; i < deps.size(); ++i) {
            Dependency dep = deps.get(i);
            map.putIfAbsent(DependencyUtils.getKey(dep.getArtifact()), dep);
        }
    }

    public static List<Dependency> mergeDependencies(List<Dependency> dominant, List<Dependency> recessive, Map<ArtifactKey, Dependency> managedVersions, Set<String> excludedScopes) {
        ArtifactKey key;
        if (dominant.isEmpty() && recessive.isEmpty()) {
            return List.of();
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>(dominant.size() + recessive.size());
        HashMap<ArtifactKey, Dependency> dominantMap = new HashMap<ArtifactKey, Dependency>(dominant.size());
        for (Dependency dep : dominant) {
            if (excludedScopes.contains(dep.getScope())) continue;
            result.add(dep);
            key = DependencyUtils.getKey(dep.getArtifact());
            if (managedVersions.containsKey(key)) continue;
            dominantMap.put(key, dep);
        }
        for (Dependency dep : recessive) {
            Dependency managed;
            if (excludedScopes.contains(dep.getScope()) || dominantMap.containsKey(key = DependencyUtils.getKey(dep.getArtifact()))) continue;
            if (dep.getArtifact().getVersion() == null && (managed = managedVersions.get(key)) != null) {
                dep = dep.setArtifact(dep.getArtifact().setVersion(managed.getArtifact().getVersion()));
            }
            result.add(dep);
        }
        return result;
    }

    public static Artifact toArtifact(String str) {
        String artifactId;
        String classifier = "";
        String type = "jar";
        String version = null;
        int offset = 0;
        int colon = str.indexOf(58, offset);
        int length = str.length();
        if (colon < offset + 1 || colon == length - 1) {
            DependencyUtils.illegalDependencyFormat(str);
        }
        String groupId = str.substring(offset, colon);
        offset = colon + 1;
        if ((colon = str.indexOf(58, offset)) < 0) {
            artifactId = str.substring(offset, length);
        } else {
            if (colon == length - 1) {
                DependencyUtils.illegalDependencyFormat(str);
            }
            artifactId = str.substring(offset, colon);
            offset = colon + 1;
            if ((colon = str.indexOf(58, offset)) < 0) {
                version = str.substring(offset, length);
            } else {
                if (colon == length - 1) {
                    DependencyUtils.illegalDependencyFormat(str);
                }
                type = str.substring(offset, colon);
                offset = colon + 1;
                if ((colon = str.indexOf(58, offset)) < 0) {
                    version = str.substring(offset, length);
                } else {
                    if (colon == length - 1) {
                        DependencyUtils.illegalDependencyFormat(str);
                    }
                    classifier = type;
                    type = str.substring(offset, colon);
                    version = str.substring(colon + 1);
                }
            }
        }
        return new DefaultArtifact(groupId, artifactId, classifier, type, version);
    }

    private static void illegalDependencyFormat(String str) {
        throw new IllegalArgumentException("Bad artifact coordinates " + str + ", expected format is <groupId>:<artifactId>[:<extension>|[:<classifier>:<extension>]]:<version>");
    }

    public static ResolvedDependencyBuilder newDependencyBuilder(DependencyNode node, MavenArtifactResolver resolver) throws BootstrapMavenException {
        Artifact artifact = node.getDependency().getArtifact();
        if (artifact.getFile() == null) {
            artifact = resolver.resolve(artifact, node.getRepositories()).getArtifact();
        }
        int flags = 0;
        if (node.getDependency().isOptional()) {
            flags |= 1;
        }
        WorkspaceModule module = null;
        if (resolver.getProjectModuleResolver() != null && (module = resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())) != null) {
            flags |= 0x20;
        }
        return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(artifact, module).setScope(node.getDependency().getScope())).setFlags(flags);
    }

    public static ResolvedDependencyBuilder toAppArtifact(Artifact artifact, WorkspaceModule module) {
        return ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setWorkspaceModule(module).setGroupId(artifact.getGroupId())).setArtifactId(artifact.getArtifactId())).setClassifier(artifact.getClassifier())).setType(artifact.getExtension())).setVersion(artifact.getVersion())).setResolvedPaths((PathCollection)(artifact.getFile() == null ? PathList.empty() : PathList.of((Path[])new Path[]{artifact.getFile().toPath()})));
    }

    public static boolean hasWinner(DependencyNode node) {
        return node.getData().containsKey("conflict.winner") && node.getChildren().isEmpty();
    }

    public static DependencyNode getWinner(DependencyNode node) {
        DependencyNode winner = (DependencyNode)node.getData().get("conflict.winner");
        return winner == null || !node.getChildren().isEmpty() ? null : winner;
    }
}

