/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.jboss.logging.Logger;

public class CurationResult {
    private static final Logger log = Logger.getLogger(CurationResult.class);
    private final ApplicationModel appModel;
    private final Collection<io.quarkus.maven.dependency.Dependency> updatedDependencies;
    private final boolean fromState;
    private final ResolvedDependency appArtifact;
    private final ResolvedDependency stateArtifact;
    private boolean persisted;

    public CurationResult(ApplicationModel appModel) {
        this(appModel, Collections.emptyList(), false, null, null);
    }

    public CurationResult(ApplicationModel appModel, Collection<io.quarkus.maven.dependency.Dependency> updatedDependencies, boolean fromState, ResolvedDependency appArtifact, ResolvedDependency stateArtifact) {
        this.appModel = appModel;
        this.updatedDependencies = updatedDependencies;
        this.fromState = fromState;
        this.appArtifact = appArtifact;
        this.stateArtifact = stateArtifact;
    }

    @Deprecated
    public AppModel getAppModel() {
        return BootstrapUtils.convert((ApplicationModel)this.appModel);
    }

    public ApplicationModel getApplicationModel() {
        return this.appModel;
    }

    public Collection<io.quarkus.maven.dependency.Dependency> getUpdatedDependencies() {
        return this.updatedDependencies;
    }

    public boolean isFromState() {
        return this.fromState;
    }

    public ResolvedDependency getStateArtifact() {
        return this.stateArtifact;
    }

    public boolean hasUpdatedDeps() {
        return !this.updatedDependencies.isEmpty();
    }

    public void persist(AppModelResolver resolver) {
        ArtifactCoords stateArtifact;
        Path stateDir;
        if (this.persisted || this.fromState && !this.hasUpdatedDeps()) {
            log.info((Object)"Skipping provisioning state persistence");
            return;
        }
        log.info((Object)"Persisting provisioning state");
        try {
            stateDir = Files.createTempDirectory("quarkus-state", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path statePom = stateDir.resolve("pom.xml");
        if (this.stateArtifact == null) {
            stateArtifact = ModelUtils.getStateArtifact((ArtifactCoords)this.appArtifact);
        } else {
            ResolvedDependency currentCoords = this.stateArtifact;
            stateArtifact = new GACTV(currentCoords.getGroupId(), currentCoords.getArtifactId(), currentCoords.getClassifier(), currentCoords.getType(), String.valueOf(Long.valueOf(currentCoords.getVersion()) + 1L));
        }
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(stateArtifact.getGroupId());
        model.setArtifactId(stateArtifact.getArtifactId());
        model.setPackaging(stateArtifact.getType());
        model.setVersion(stateArtifact.getVersion());
        model.addProperty("creator.app.groupId", this.appArtifact.getGroupId());
        model.addProperty("creator.app.artifactId", this.appArtifact.getArtifactId());
        String classifier = this.appArtifact.getClassifier();
        if (!classifier.isEmpty()) {
            model.addProperty("creator.app.classifier", classifier);
        }
        model.addProperty("creator.app.type", this.appArtifact.getType());
        model.addProperty("creator.app.version", this.appArtifact.getVersion());
        Dependency appDep = new Dependency();
        appDep.setGroupId("${creator.app.groupId}");
        appDep.setArtifactId("${creator.app.artifactId}");
        if (!classifier.isEmpty()) {
            appDep.setClassifier("${creator.app.classifier}");
        }
        appDep.setType("${creator.app.type}");
        appDep.setVersion("${creator.app.version}");
        appDep.setScope("compile");
        model.addDependency(appDep);
        if (!this.updatedDependencies.isEmpty()) {
            for (io.quarkus.maven.dependency.Dependency dep : this.updatedDependencies) {
                String groupId = dep.getGroupId();
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(groupId);
                exclusion.setArtifactId(dep.getArtifactId());
                appDep.addExclusion(exclusion);
                Dependency updateDep = new Dependency();
                updateDep.setGroupId(groupId);
                updateDep.setArtifactId(dep.getArtifactId());
                String updateClassifier = dep.getClassifier();
                if (updateClassifier != null && !updateClassifier.isEmpty()) {
                    updateDep.setClassifier(updateClassifier);
                }
                updateDep.setType(dep.getType());
                updateDep.setVersion(dep.getVersion());
                updateDep.setScope(dep.getScope());
                model.addDependency(updateDep);
            }
        }
        try {
            ModelUtils.persistModel((Path)statePom, (Model)model);
            ((BootstrapAppModelResolver)resolver).install(stateArtifact, statePom);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to persist application state artifact", e);
        }
        this.persisted = true;
        log.info((Object)("Persisted provisioning state as " + stateArtifact));
    }
}

