/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import java.util.ArrayList;
import java.util.List;

public class AppModel {
    private final AppArtifact appArtifact;
    private final List<AppDependency> deploymentDeps;
    private final List<AppDependency> userDeps;
    private List<AppDependency> allDeps;

    public AppModel(AppArtifact appArtifact, List<AppDependency> userDeps, List<AppDependency> deploymentDeps) {
        this.appArtifact = appArtifact;
        this.userDeps = userDeps;
        this.deploymentDeps = deploymentDeps;
    }

    public List<AppDependency> getAllDependencies() throws BootstrapDependencyProcessingException {
        if (this.allDeps == null) {
            this.allDeps = new ArrayList<AppDependency>(this.userDeps.size() + this.deploymentDeps.size());
            this.allDeps.addAll(this.userDeps);
            this.allDeps.addAll(this.deploymentDeps);
        }
        return this.allDeps;
    }

    public AppArtifact getAppArtifact() {
        return this.appArtifact;
    }

    public List<AppDependency> getUserDependencies() throws BootstrapDependencyProcessingException {
        return this.userDeps;
    }

    public List<AppDependency> getDeploymentDependencies() throws BootstrapDependencyProcessingException {
        return this.deploymentDeps;
    }
}

