/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.KnownCompatibleBeanArchiveBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class KnownCompatibleBeanArchives {
    private final Map<KnownCompatibleBeanArchiveBuildItem.Reason, Set<Key>> compatArchivesByReason;

    KnownCompatibleBeanArchives(List<KnownCompatibleBeanArchiveBuildItem> list) {
        HashMap<KnownCompatibleBeanArchiveBuildItem.Reason, Set<Key>> allCompatArchivesMap = new HashMap<KnownCompatibleBeanArchiveBuildItem.Reason, Set<Key>>();
        for (KnownCompatibleBeanArchiveBuildItem item : list) {
            for (KnownCompatibleBeanArchiveBuildItem.Reason reason : item.reasons) {
                allCompatArchivesMap.computeIfAbsent(reason, unused -> new HashSet()).add(new Key(item.groupId, item.artifactId, item.classifier));
            }
        }
        this.compatArchivesByReason = allCompatArchivesMap;
    }

    boolean isKnownCompatible(ApplicationArchive archive, KnownCompatibleBeanArchiveBuildItem.Reason reason) {
        ArtifactKey artifact = archive.getKey();
        if (artifact == null) {
            return false;
        }
        Set<Key> archives = this.compatArchivesByReason.get((Object)reason);
        return archives == null ? false : archives.contains(new Key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier()));
    }

    static class Key {
        final String groupId;
        final String artifactId;
        final String classifier;

        Key(String groupId, String artifactId, String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.groupId, key.groupId) && Objects.equals(this.artifactId, key.artifactId) && Objects.equals(this.classifier, key.classifier);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.classifier);
        }
    }
}

