/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.netty.buffer.ByteBuf;
import io.undertow.UndertowLogger;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.DateUtils;
import io.undertow.util.LegacyCookieSupport;
import io.undertow.util.ParameterLimitException;
import io.undertow.util.URLUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class Connectors {
    public static void flattenCookies(HttpServerExchange exchange) {
        Map<String, Cookie> cookies = exchange.getResponseCookiesInternal();
        boolean enableRfc6265Validation = exchange.getUndertowOptions().get(UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION, false);
        if (cookies != null) {
            for (Map.Entry<String, Cookie> entry : cookies.entrySet()) {
                exchange.addResponseHeader("Set-Cookie", Connectors.getCookieString(entry.getValue(), enableRfc6265Validation));
            }
        }
    }

    public static boolean isRunningHandlerChain(HttpServerExchange exchange) {
        return exchange.isExecutingHandlerChain();
    }

    public static void ungetRequestBytes(HttpServerExchange exchange, ByteBuf buffer) {
        throw new RuntimeException("NYI");
    }

    private static String getCookieString(Cookie cookie, boolean enableRfc6265Validation) {
        if (enableRfc6265Validation) {
            return Connectors.addRfc6265ResponseCookieToExchange(cookie);
        }
        switch (LegacyCookieSupport.adjustedCookieVersion(cookie)) {
            case 0: {
                return Connectors.addVersion0ResponseCookieToExchange(cookie);
            }
        }
        return Connectors.addVersion1ResponseCookieToExchange(cookie);
    }

    public static void setRequestStartTime(HttpServerExchange exchange) {
        exchange.setRequestStartTime(System.nanoTime());
    }

    public static void setRequestStartTime(HttpServerExchange existing, HttpServerExchange newExchange) {
        newExchange.setRequestStartTime(existing.getRequestStartTime());
    }

    private static String addRfc6265ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        if (cookie.getValue() != null) {
            header.append(cookie.getValue());
        }
        if (cookie.getPath() != null) {
            header.append("; Path=");
            header.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() >= 0) {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
            if (cookie.getExpires() == null) {
                if (cookie.getMaxAge() == 0) {
                    Date expires = new Date();
                    expires.setTime(0L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                } else if (cookie.getMaxAge() > 0) {
                    Date expires = new Date();
                    expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue() * 1000L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                }
            }
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
        }
        if (cookie.getComment() != null && !cookie.getComment().isEmpty()) {
            header.append("; Comment=");
            header.append(cookie.getComment());
        }
        if (cookie.isSameSite()) {
            if (cookie.getSameSiteMode() != null && !cookie.getSameSiteMode().isEmpty()) {
                header.append("; SameSite=");
                header.append(cookie.getSameSiteMode());
            } else {
                header.append("; SameSite");
            }
        }
        return header.toString();
    }

    private static String addVersion0ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        if (cookie.getValue() != null) {
            LegacyCookieSupport.maybeQuote(header, cookie.getValue());
        }
        if (cookie.getPath() != null) {
            header.append("; path=");
            LegacyCookieSupport.maybeQuote(header, cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; domain=");
            LegacyCookieSupport.maybeQuote(header, cookie.getDomain());
        }
        if (cookie.isSecure()) {
            header.append("; secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toOldCookieDateString(cookie.getExpires()));
        } else if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() >= 0) {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
            if (cookie.getMaxAge() == 0) {
                Date expires = new Date();
                expires.setTime(0L);
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            } else if (cookie.getMaxAge() > 0) {
                Date expires = new Date();
                expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue() * 1000L);
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            }
        }
        if (cookie.isSameSite()) {
            if (cookie.getSameSiteMode() != null && !cookie.getSameSiteMode().isEmpty()) {
                header.append("; SameSite=");
                header.append(cookie.getSameSiteMode());
            } else {
                header.append("; SameSite");
            }
        }
        return header.toString();
    }

    private static String addVersion1ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        if (cookie.getValue() != null) {
            LegacyCookieSupport.maybeQuote(header, cookie.getValue());
        }
        header.append("; Version=1");
        if (cookie.getPath() != null) {
            header.append("; Path=");
            LegacyCookieSupport.maybeQuote(header, cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            LegacyCookieSupport.maybeQuote(header, cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() >= 0) {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
            if (cookie.getExpires() == null) {
                if (cookie.getMaxAge() == 0) {
                    Date expires = new Date();
                    expires.setTime(0L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                } else if (cookie.getMaxAge() > 0) {
                    Date expires = new Date();
                    expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue() * 1000L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                }
            }
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
        }
        if (cookie.getComment() != null && !cookie.getComment().isEmpty()) {
            header.append("; Comment=");
            LegacyCookieSupport.maybeQuote(header, cookie.getComment());
        }
        if (cookie.isSameSite()) {
            if (cookie.getSameSiteMode() != null && !cookie.getSameSiteMode().isEmpty()) {
                header.append("; SameSite=");
                header.append(cookie.getSameSiteMode());
            } else {
                header.append("; SameSite");
            }
        }
        return header.toString();
    }

    public static void executeRootHandler(HttpHandler handler, HttpServerExchange exchange) {
        try {
            exchange.beginExecutingHandlerChain();
            handler.handleRequest(exchange);
            exchange.endExecutingHandlerChain();
            boolean resumed = exchange.delegate.isIoOperationQueued();
            if (exchange.isDispatched()) {
                if (resumed) {
                    UndertowLogger.REQUEST_LOGGER.resumedAndDispatched();
                    exchange.setStatusCode(500);
                    exchange.endExchange();
                    return;
                }
                Runnable dispatchTask = exchange.getDispatchTask();
                Executor executor = exchange.getDispatchExecutor();
                exchange.setDispatchExecutor(null);
                exchange.unDispatch();
                if (dispatchTask != null) {
                    executor = executor == null ? exchange.getWorker() : executor;
                    try {
                        executor.execute(dispatchTask);
                    }
                    catch (RejectedExecutionException e) {
                        UndertowLogger.REQUEST_LOGGER.debug("Failed to dispatch to worker", e);
                        exchange.setStatusCode(503);
                        exchange.endExchange();
                    }
                }
            } else if (!resumed) {
                exchange.endExchange();
            } else {
                exchange.runResumeReadWrite();
            }
        }
        catch (Throwable t) {
            exchange.putAttachment(DefaultResponseListener.EXCEPTION, t);
            exchange.endExecutingHandlerChain();
            if (!exchange.isResponseStarted()) {
                exchange.setStatusCode(500);
            }
            if (t instanceof IOException) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)t);
            } else {
                UndertowLogger.REQUEST_LOGGER.undertowRequestFailed(t, exchange);
            }
            exchange.endExchange();
        }
    }

    @Deprecated
    public static void setExchangeRequestPath(HttpServerExchange exchange, String encodedPath, String charset, boolean decode, boolean allowEncodedSlash, StringBuilder decodeBuffer) {
        try {
            Connectors.setExchangeRequestPath(exchange, encodedPath, charset, decode, allowEncodedSlash, decodeBuffer, (Integer)exchange.getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, (Object)1000));
        }
        catch (ParameterLimitException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setExchangeRequestPath(HttpServerExchange exchange, String encodedPath, String charset, boolean decode, boolean allowEncodedSlash, StringBuilder decodeBuffer, int maxParameters) throws ParameterLimitException {
        boolean requiresDecode = false;
        StringBuilder pathBuilder = new StringBuilder();
        int currentPathPartIndex = 0;
        for (int i = 0; i < encodedPath.length(); ++i) {
            String part;
            String encodedPart;
            char c = encodedPath.charAt(i);
            if (c == '?') {
                encodedPart = encodedPath.substring(currentPathPartIndex, i);
                part = requiresDecode ? URLUtils.decode(encodedPart, charset, allowEncodedSlash, false, decodeBuffer) : encodedPart;
                pathBuilder.append(part);
                part = pathBuilder.toString();
                exchange.setRequestPath(part);
                exchange.setRelativePath(part);
                exchange.setRequestURI(encodedPath.substring(0, i));
                String qs = encodedPath.substring(i + 1);
                exchange.setQueryString(qs);
                URLUtils.parseQueryString(qs, exchange, charset, decode, maxParameters);
                return;
            }
            if (c == ';') {
                encodedPart = encodedPath.substring(currentPathPartIndex, i);
                part = requiresDecode ? URLUtils.decode(encodedPart, charset, allowEncodedSlash, false, decodeBuffer) : encodedPart;
                pathBuilder.append(part);
                exchange.setRequestURI(encodedPath);
                currentPathPartIndex = i + 1 + URLUtils.parsePathParams(encodedPath.substring(i + 1), exchange, charset, decode, maxParameters);
                i = currentPathPartIndex - 1;
                continue;
            }
            if (c != '%' && c != '+') continue;
            requiresDecode = decode;
        }
        String encodedPart = encodedPath.substring(currentPathPartIndex);
        String part = requiresDecode ? URLUtils.decode(encodedPart, charset, allowEncodedSlash, false, decodeBuffer) : encodedPart;
        pathBuilder.append(part);
        part = pathBuilder.toString();
        exchange.setRequestPath(part);
        exchange.setRelativePath(part);
        exchange.setRequestURI(encodedPath);
    }
}

