/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Field;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;

public class EnumField
extends Field<EnumGroup.Value> {
    final EnumGroup.Value ev;
    EnumGroup enumGroup;
    boolean defaultValueSet;

    public EnumField() {
        this((EnumGroup.Value)null);
    }

    public EnumField(EnumGroup enumGroup) {
        this((EnumGroup.Value)null);
        this.enumGroup = enumGroup;
    }

    public EnumField(EnumGroup.Value ev) {
        super(true);
        this.ev = ev;
    }

    public EnumGroup.Value getEv() {
        return this.ev;
    }

    @Override
    public void putExtraOption(String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            String ofOwner;
            Proto proto;
            if (this.owner != null) {
                proto = this.owner.getProto();
                ofOwner = " of " + this.owner.getRelativeName();
            } else if (this.ev != null) {
                proto = this.enumGroup.getProto();
                ofOwner = " of the enum " + this.enumGroup.getRelativeName();
            } else {
                proto = null;
                ofOwner = "";
            }
            throw EnumField.err("The field " + this.name + ofOwner + " contains a duplicate option: " + key, proto);
        }
    }

    @Override
    public boolean isDefaultValueSet() {
        return this.defaultValueSet;
    }

    public EnumGroup getEnumGroup() {
        return this.enumGroup;
    }

    @Override
    public String getJavaType() {
        StringBuilder buffer = new StringBuilder();
        if (this.enumGroup.isNested()) {
            if (this.enumGroup.parentMessage == this.owner) {
                buffer.append(this.enumGroup.name);
            } else {
                Message.computeName(this.enumGroup.parentMessage, this.owner, buffer);
                buffer.append('.').append(this.enumGroup.name);
            }
        } else if (this.enumGroup.getProto().getJavaPackageName().equals(this.owner.getProto().getJavaPackageName())) {
            buffer.append(this.enumGroup.name);
        } else {
            buffer.append(this.enumGroup.getProto().getJavaPackageName()).append('.').append(this.enumGroup.getName());
        }
        return buffer.toString();
    }

    public String getRegularType() {
        String javaType = this.getJavaType();
        Proto egProto = this.enumGroup.getProto();
        String javaPackage = egProto.getJavaPackageName();
        String protoPackage = egProto.getPackageName();
        if (javaType.startsWith(javaPackage) && !javaPackage.equals(protoPackage)) {
            return javaType.replace(javaPackage, protoPackage);
        }
        return javaType;
    }

    @Override
    public String getDefaultValueAsString() {
        return this.getJavaType() + "." + ((EnumGroup.Value)this.getDefaultValue()).getName();
    }

    public boolean isSamePackage() {
        return this.getOwner().getProto() == this.getEnumGroup().getProto();
    }

    public String getRelativePath() {
        if (this.isSamePackage()) {
            return "";
        }
        String currentPackage = this.getOwner().getProto().getPackageName();
        String targetPackage = this.getEnumGroup().getProto().getPackageName();
        String path = "../";
        int idx = currentPackage.indexOf(46);
        while (idx != -1) {
            path = path + "../";
            idx = currentPackage.indexOf(46, idx + 1);
        }
        return path + targetPackage.replace('.', '/') + "/";
    }

    @Override
    public Proto getProto() {
        return this.ev != null ? this.ev.getProto() : super.getProto();
    }

    @Override
    public String getProtoType() {
        return this.getRegularType();
    }
}

