// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

package io.prometheus.metrics.shaded.com_google_protobuf_4_29_1;

import io.prometheus.metrics.shaded.com_google_protobuf_4_29_1.Descriptors.EnumDescriptor;
import io.prometheus.metrics.shaded.com_google_protobuf_4_29_1.Descriptors.EnumValueDescriptor;

/** Interface of useful methods added to all enums generated by the protocol compiler. */
public interface ProtocolMessageEnum extends Internal.EnumLite {

  /** Return the value's numeric value as defined in the .proto file. */
  @Override
  int getNumber();

  /**
   * Return the value's descriptor, which contains information such as value name, number, and type.
   */
  EnumValueDescriptor getValueDescriptor();

  /**
   * Return the enum type's descriptor, which contains information about each defined value, etc.
   */
  EnumDescriptor getDescriptorForType();
}
