/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.tomcat.Apr;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSsl {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSsl.class);
    private static final String LINUX = "linux";
    private static final String UNKNOWN = "unknown";
    private static final Throwable UNAVAILABILITY_CAUSE;
    static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_OPENSSL_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_JAVA_CIPHER_SUITES;
    private static final boolean SUPPORTS_KEYMANAGER_FACTORY;
    private static final boolean USE_KEYMANAGER_FACTORY;
    static final String PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    static final String PROTOCOL_SSL_V2 = "SSLv2";
    static final String PROTOCOL_SSL_V3 = "SSLv3";
    static final String PROTOCOL_TLS_V1 = "TLSv1";
    static final String PROTOCOL_TLS_V1_1 = "TLSv1.1";
    static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    static final Set<String> SUPPORTED_PROTOCOLS_SET;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doesSupportProtocol(long aprPool, int protocol) {
        long sslCtx = -1L;
        try {
            sslCtx = SSLContext.make((long)aprPool, (int)protocol, (int)2);
            boolean bl = true;
            return bl;
        }
        catch (Exception ignore) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sslCtx != -1L) {
                SSLContext.free((long)sslCtx);
            }
        }
    }

    private static boolean isNettyTcnative() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean run() {
                Boolean bl;
                InputStream is = null;
                try {
                    is = Apr.class.getResourceAsStream("/org/apache/tomcat/apr.properties");
                    Properties props = new Properties();
                    props.load(is);
                    String info = props.getProperty("tcn.info");
                    bl = info != null && info.startsWith("netty-tcnative");
                    if (is == null) return bl;
                }
                catch (Throwable ignore) {
                    try {
                        Boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                try {
                    is.close();
                    return bl;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
        });
    }

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isAlpnSupported() {
        return (long)OpenSsl.version() >= 0x10002000L;
    }

    public static int version() {
        if (OpenSsl.isAvailable()) {
            return SSL.version();
        }
        return -1;
    }

    public static String versionString() {
        if (OpenSsl.isAvailable()) {
            return SSL.versionString();
        }
        return null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    @Deprecated
    public static Set<String> availableCipherSuites() {
        return OpenSsl.availableOpenSslCipherSuites();
    }

    public static Set<String> availableOpenSslCipherSuites() {
        return AVAILABLE_OPENSSL_CIPHER_SUITES;
    }

    public static Set<String> availableJavaCipherSuites() {
        return AVAILABLE_JAVA_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String cipherSuite) {
        String converted = CipherSuiteConverter.toOpenSsl(cipherSuite);
        if (converted != null) {
            cipherSuite = converted;
        }
        return AVAILABLE_OPENSSL_CIPHER_SUITES.contains(cipherSuite);
    }

    public static boolean supportsKeyManagerFactory() {
        return SUPPORTS_KEYMANAGER_FACTORY;
    }

    static boolean useKeyManagerFactory() {
        return USE_KEYMANAGER_FACTORY;
    }

    static boolean isError(long errorCode) {
        return errorCode != 0L;
    }

    static long memoryAddress(ByteBuf buf) {
        assert (buf.isDirect());
        return buf.hasMemoryAddress() ? buf.memoryAddress() : Buffer.address((ByteBuffer)buf.nioBuffer());
    }

    private OpenSsl() {
    }

    private static void loadTcNative() throws Exception {
        String os = OpenSsl.normalizeOs(SystemPropertyUtil.get((String)"os.name", (String)""));
        String arch = OpenSsl.normalizeArch(SystemPropertyUtil.get((String)"os.arch", (String)""));
        LinkedHashSet<String> libNames = new LinkedHashSet<String>(3);
        libNames.add("netty-tcnative-" + os + '-' + arch);
        if (LINUX.equalsIgnoreCase(os)) {
            libNames.add("netty-tcnative-" + os + '-' + arch + "-fedora");
        }
        libNames.add("netty-tcnative");
        NativeLibraryLoader.loadFirstAvailable((ClassLoader)SSL.class.getClassLoader(), (String[])libNames.toArray(new String[libNames.size()]));
    }

    private static void initializeTcNative() throws Exception {
        Library.initialize((String)"provided");
        SSL.initialize(null);
    }

    private static String normalizeOs(String value) {
        if ((value = OpenSsl.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith(LINUX)) {
            return LINUX;
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = OpenSsl.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    static void releaseIfNeeded(ReferenceCounted counted) {
        if (counted.refCnt() > 0) {
            ReferenceCountUtil.safeRelease((Object)counted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Throwable cause = null;
        try {
            Class.forName("org.apache.tomcat.jni.SSL", false, OpenSsl.class.getClassLoader());
        }
        catch (ClassNotFoundException t) {
            cause = t;
            logger.debug("netty-tcnative not in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
        }
        if (cause == null) {
            try {
                OpenSsl.loadTcNative();
            }
            catch (Throwable t) {
                cause = t;
                logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable, unless the " + "application has already loaded the symbols by some other means. " + "See http://netty.io/wiki/forked-tomcat-native.html for more information.", t);
            }
            try {
                OpenSsl.initializeTcNative();
                cause = null;
            }
            catch (Throwable t) {
                if (cause == null) {
                    cause = t;
                }
                logger.debug("Failed to initialize netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable. " + "See http://netty.io/wiki/forked-tomcat-native.html for more information.", t);
            }
        }
        if (cause == null && !OpenSsl.isNettyTcnative()) {
            logger.debug("incompatible tcnative in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
            cause = new ClassNotFoundException("incompatible tcnative in the classpath");
        }
        UNAVAILABILITY_CAUSE = cause;
        if (cause == null) {
            LinkedHashSet<String> availableOpenSslCipherSuites = new LinkedHashSet<String>(128);
            boolean supportsKeyManagerFactory = false;
            boolean useKeyManagerFactory = false;
            long aprPool = Pool.create((long)0L);
            try {
                long sslCtx = SSLContext.make((long)aprPool, (int)31, (int)1);
                long privateKeyBio = 0L;
                long certBio = 0L;
                try {
                    SSLContext.setOptions((long)sslCtx, (int)4095);
                    SSLContext.setCipherSuite((long)sslCtx, (String)"ALL");
                    long ssl = SSL.newSSL((long)sslCtx, (boolean)true);
                    try {
                        for (String c : SSL.getCiphers((long)ssl)) {
                            if (c == null || c.length() == 0 || availableOpenSslCipherSuites.contains(c)) continue;
                            availableOpenSslCipherSuites.add(c);
                        }
                        try {
                            SelfSignedCertificate cert = new SelfSignedCertificate();
                            certBio = OpenSslContext.toBIO(cert.cert());
                            SSL.setCertificateChainBio((long)ssl, (long)certBio, (boolean)false);
                            supportsKeyManagerFactory = true;
                            useKeyManagerFactory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                                @Override
                                public Boolean run() {
                                    return SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.useKeyManagerFactory", (boolean)true);
                                }
                            });
                        }
                        catch (Throwable ignore) {
                            logger.debug("KeyManagerFactory not supported.");
                        }
                    }
                    finally {
                        SSL.freeSSL((long)ssl);
                        if (privateKeyBio != 0L) {
                            SSL.freeBIO((long)privateKeyBio);
                        }
                        if (certBio != 0L) {
                            SSL.freeBIO((long)certBio);
                        }
                    }
                }
                finally {
                    SSLContext.free((long)sslCtx);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", (Throwable)e);
            }
            finally {
                Pool.destroy((long)aprPool);
            }
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.unmodifiableSet(availableOpenSslCipherSuites);
            LinkedHashSet<String> availableJavaCipherSuites = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() * 2);
            for (String cipher : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                availableJavaCipherSuites.add(CipherSuiteConverter.toJava(cipher, "TLS"));
                availableJavaCipherSuites.add(CipherSuiteConverter.toJava(cipher, "SSL"));
            }
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.unmodifiableSet(availableJavaCipherSuites);
            LinkedHashSet<String> availableCipherSuites = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() + AVAILABLE_JAVA_CIPHER_SUITES.size());
            for (String cipher : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                availableCipherSuites.add(cipher);
            }
            for (String cipher : AVAILABLE_JAVA_CIPHER_SUITES) {
                availableCipherSuites.add(cipher);
            }
            AVAILABLE_CIPHER_SUITES = availableCipherSuites;
            SUPPORTS_KEYMANAGER_FACTORY = supportsKeyManagerFactory;
            USE_KEYMANAGER_FACTORY = useKeyManagerFactory;
            long pool = Pool.create((long)0L);
            LinkedHashSet<String> protocols = new LinkedHashSet<String>(6);
            protocols.add(PROTOCOL_SSL_V2_HELLO);
            try {
                if (OpenSsl.doesSupportProtocol(pool, 1)) {
                    protocols.add(PROTOCOL_SSL_V2);
                }
                if (OpenSsl.doesSupportProtocol(pool, 2)) {
                    protocols.add(PROTOCOL_SSL_V3);
                }
                if (OpenSsl.doesSupportProtocol(pool, 4)) {
                    protocols.add(PROTOCOL_TLS_V1);
                }
                if (OpenSsl.doesSupportProtocol(pool, 8)) {
                    protocols.add(PROTOCOL_TLS_V1_1);
                }
                if (OpenSsl.doesSupportProtocol(pool, 16)) {
                    protocols.add(PROTOCOL_TLS_V1_2);
                }
            }
            finally {
                Pool.destroy((long)aprPool);
            }
            SUPPORTED_PROTOCOLS_SET = Collections.unmodifiableSet(protocols);
        } else {
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_CIPHER_SUITES = Collections.emptySet();
            SUPPORTS_KEYMANAGER_FACTORY = false;
            USE_KEYMANAGER_FACTORY = false;
            SUPPORTED_PROTOCOLS_SET = Collections.emptySet();
        }
    }
}

