/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.List;

public abstract class HttpObjectDecoder
extends ReplayingDecoder<State> {
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    private ByteBuf content;
    private HttpMessage message;
    private long chunkSize;
    private int headerSize;
    private int contentRead;

    protected HttpObjectDecoder() {
        this(4096, 8192, 8192, true);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported) {
        super((Object)State.SKIP_CONTROL_CHARS);
        if (maxInitialLineLength <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be a positive integer: " + maxInitialLineLength);
        }
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        if (maxChunkSize < 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderSize = maxHeaderSize;
        this.maxChunkSize = maxChunkSize;
        this.chunkedSupported = chunkedSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        switch ((State)((Object)this.state())) {
            case SKIP_CONTROL_CHARS: {
                try {
                    HttpObjectDecoder.skipControlCharacters(buffer);
                    this.checkpoint((Object)State.READ_INITIAL);
                }
                finally {
                    this.checkpoint();
                }
            }
            case READ_INITIAL: {
                try {
                    String[] initialLine = HttpObjectDecoder.splitInitialLine(HttpObjectDecoder.readLine(buffer, this.maxInitialLineLength));
                    if (initialLine.length < 3) {
                        this.checkpoint((Object)State.SKIP_CONTROL_CHARS);
                        return null;
                    }
                    this.message = this.createMessage(initialLine);
                    this.checkpoint((Object)State.READ_HEADER);
                }
                catch (Exception e) {
                    return this.invalidMessage(e);
                }
            }
            case READ_HEADER: {
                try {
                    State nextState = this.readHeaders(buffer);
                    this.checkpoint((Object)nextState);
                    if (nextState == State.READ_CHUNK_SIZE) {
                        if (!this.chunkedSupported) {
                            throw new IllegalArgumentException("Chunked messages not supported");
                        }
                        return this.message;
                    }
                    if (nextState == State.SKIP_CONTROL_CHARS) {
                        return this.reset();
                    }
                    long contentLength = HttpHeaders.getContentLength(this.message, -1L);
                    if (contentLength == 0L || contentLength == -1L && this.isDecodingRequest()) {
                        this.content = Unpooled.EMPTY_BUFFER;
                        return this.reset();
                    }
                    switch (nextState) {
                        case READ_FIXED_LENGTH_CONTENT: {
                            if (contentLength <= (long)this.maxChunkSize && !HttpHeaders.is100ContinueExpected(this.message)) break;
                            this.checkpoint((Object)State.READ_FIXED_LENGTH_CONTENT_AS_CHUNKS);
                            this.chunkSize = HttpHeaders.getContentLength(this.message, -1L);
                            return this.message;
                        }
                        case READ_VARIABLE_LENGTH_CONTENT: {
                            if (buffer.readableBytes() <= this.maxChunkSize && !HttpHeaders.is100ContinueExpected(this.message)) break;
                            this.checkpoint((Object)State.READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS);
                            return this.message;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected state: " + (Object)((Object)nextState));
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    return this.invalidMessage(e);
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = this.actualReadableBytes();
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                return new Object[]{this.message, new DefaultHttpContent(buffer.readBytes(toRead))};
            }
            case READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS: {
                int toRead = this.actualReadableBytes();
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                ByteBuf content = buffer.readBytes(toRead);
                if (!buffer.isReadable()) {
                    this.reset();
                    return new DefaultLastHttpContent(content);
                }
                return new DefaultHttpContent(content);
            }
            case READ_FIXED_LENGTH_CONTENT: {
                return this.readFixedLengthContent(buffer);
            }
            case READ_FIXED_LENGTH_CONTENT_AS_CHUNKS: {
                long chunkSize = this.chunkSize;
                int readLimit = this.actualReadableBytes();
                if (readLimit == 0) {
                    return null;
                }
                int toRead = readLimit;
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if ((long)toRead > chunkSize) {
                    toRead = (int)chunkSize;
                }
                ByteBuf content = buffer.readBytes(toRead);
                chunkSize = chunkSize > (long)toRead ? (chunkSize -= (long)toRead) : 0L;
                this.chunkSize = chunkSize;
                if (chunkSize == 0L) {
                    this.reset();
                    return new DefaultLastHttpContent(content);
                }
                return new DefaultHttpContent(content);
            }
            case READ_CHUNK_SIZE: {
                try {
                    String line = HttpObjectDecoder.readLine(buffer, this.maxInitialLineLength);
                    int chunkSize = HttpObjectDecoder.getChunkSize(line);
                    this.chunkSize = chunkSize;
                    if (chunkSize == 0) {
                        this.checkpoint((Object)State.READ_CHUNK_FOOTER);
                        return null;
                    }
                    if (chunkSize > this.maxChunkSize) {
                        this.checkpoint((Object)State.READ_CHUNKED_CONTENT_AS_CHUNKS);
                    } else {
                        this.checkpoint((Object)State.READ_CHUNKED_CONTENT);
                    }
                }
                catch (Exception e) {
                    return this.invalidChunk(e);
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                DefaultHttpContent chunk = new DefaultHttpContent(buffer.readBytes((int)this.chunkSize));
                this.checkpoint((Object)State.READ_CHUNK_DELIMITER);
                return chunk;
            }
            case READ_CHUNKED_CONTENT_AS_CHUNKS: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int chunkSize = (int)this.chunkSize;
                int readLimit = this.actualReadableBytes();
                if (readLimit == 0) {
                    return null;
                }
                int toRead = chunkSize;
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if (toRead > readLimit) {
                    toRead = readLimit;
                }
                DefaultHttpContent chunk = new DefaultHttpContent(buffer.readBytes(toRead));
                chunkSize = chunkSize > toRead ? (chunkSize -= toRead) : 0;
                this.chunkSize = chunkSize;
                if (chunkSize == 0) {
                    this.checkpoint((Object)State.READ_CHUNK_DELIMITER);
                }
                return chunk;
            }
            case READ_CHUNK_DELIMITER: {
                while (true) {
                    byte next;
                    if ((next = buffer.readByte()) == 13) {
                        if (buffer.readByte() != 10) continue;
                        this.checkpoint((Object)State.READ_CHUNK_SIZE);
                        return null;
                    }
                    if (next == 10) {
                        this.checkpoint((Object)State.READ_CHUNK_SIZE);
                        return null;
                    }
                    this.checkpoint();
                }
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent trailer = this.readTrailingHeaders(buffer);
                    if (this.maxChunkSize == 0) {
                        return this.reset();
                    }
                    this.reset();
                    return trailer;
                }
                catch (Exception e) {
                    return this.invalidChunk(e);
                }
            }
            case BAD_MESSAGE: {
                buffer.skipBytes(this.actualReadableBytes());
                return null;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.getStatus().code();
            if (code >= 100 && code < 200) {
                return code != 101 || res.headers().contains("Sec-WebSocket-Accept");
            }
            switch (code) {
                case 204: 
                case 205: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    private Object reset() {
        HttpMessage message = this.message;
        ByteBuf content = this.content;
        LastHttpContent httpContent = content == null || !content.isReadable() ? LastHttpContent.EMPTY_LAST_CONTENT : new DefaultLastHttpContent(content);
        Object[] messages = new Object[]{message, httpContent};
        this.content = null;
        this.message = null;
        this.checkpoint((Object)State.SKIP_CONTROL_CHARS);
        return messages;
    }

    private HttpMessage invalidMessage(Exception cause) {
        this.checkpoint((Object)State.BAD_MESSAGE);
        if (this.message != null) {
            this.message.setDecoderResult(DecoderResult.failure((Throwable)cause));
        } else {
            this.message = this.createInvalidMessage();
            this.message.setDecoderResult(DecoderResult.failure((Throwable)cause));
        }
        return this.message;
    }

    private HttpContent invalidChunk(Exception cause) {
        this.checkpoint((Object)State.BAD_MESSAGE);
        DefaultHttpContent chunk = new DefaultHttpContent(Unpooled.EMPTY_BUFFER);
        chunk.setDecoderResult(DecoderResult.failure((Throwable)cause));
        return chunk;
    }

    private static void skipControlCharacters(ByteBuf buffer) {
        char c;
        while (Character.isISOControl(c = (char)buffer.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
    }

    private Object readFixedLengthContent(ByteBuf buffer) {
        long length = HttpHeaders.getContentLength(this.message, -1L);
        assert (length <= Integer.MAX_VALUE);
        int toRead = (int)length - this.contentRead;
        if (toRead > this.actualReadableBytes()) {
            toRead = this.actualReadableBytes();
        }
        this.contentRead += toRead;
        if (length < (long)this.contentRead) {
            return new Object[]{this.message, new DefaultHttpContent(buffer.readBytes(toRead))};
        }
        if (this.content == null) {
            this.content = buffer.readBytes((int)length);
        } else {
            this.content.writeBytes(buffer, (int)length);
        }
        return this.reset();
    }

    private State readHeaders(ByteBuf buffer) {
        State nextState;
        this.headerSize = 0;
        HttpMessage message = this.message;
        HttpHeaders headers = message.headers();
        String line = this.readHeader(buffer);
        String name = null;
        String value = null;
        if (!line.isEmpty()) {
            headers.clear();
            do {
                char firstChar = line.charAt(0);
                if (name != null && (firstChar == ' ' || firstChar == '\t')) {
                    value = value + ' ' + line.trim();
                    continue;
                }
                if (name != null) {
                    headers.add(name, value);
                }
                String[] header = HttpObjectDecoder.splitHeader(line);
                name = header[0];
                value = header[1];
            } while (!(line = this.readHeader(buffer)).isEmpty());
            if (name != null) {
                headers.add(name, value);
            }
        }
        if (this.isContentAlwaysEmpty(message)) {
            HttpHeaders.removeTransferEncodingChunked(message);
            nextState = State.SKIP_CONTROL_CHARS;
        } else {
            nextState = HttpHeaders.isTransferEncodingChunked(message) ? State.READ_CHUNK_SIZE : (HttpHeaders.getContentLength(message, -1L) >= 0L ? State.READ_FIXED_LENGTH_CONTENT : State.READ_VARIABLE_LENGTH_CONTENT);
        }
        return nextState;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf buffer) {
        this.headerSize = 0;
        String line = this.readHeader(buffer);
        String lastHeader = null;
        if (!line.isEmpty()) {
            DefaultLastHttpContent trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    List<String> current = trailer.trailingHeaders().getAll(lastHeader);
                    if (current.isEmpty()) continue;
                    int lastPos = current.size() - 1;
                    String newString = current.get(lastPos) + line.trim();
                    current.set(lastPos, newString);
                    continue;
                }
                String[] header = HttpObjectDecoder.splitHeader(line);
                String name = header[0];
                if (!(name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer"))) {
                    trailer.trailingHeaders().add(name, header[1]);
                }
                lastHeader = name;
            } while (!(line = this.readHeader(buffer)).isEmpty());
            return trailer;
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readHeader(ByteBuf buffer) {
        StringBuilder sb = new StringBuilder(64);
        int headerSize = this.headerSize;
        block4: while (true) {
            char nextByte = (char)buffer.readByte();
            ++headerSize;
            switch (nextByte) {
                case '\r': {
                    nextByte = (char)buffer.readByte();
                    ++headerSize;
                    if (nextByte != '\n') break;
                    break block4;
                }
                case '\n': {
                    break block4;
                }
            }
            if (headerSize >= this.maxHeaderSize) {
                throw new TooLongFrameException("HTTP header is larger than " + this.maxHeaderSize + " bytes.");
            }
            sb.append(nextByte);
        }
        this.headerSize = headerSize;
        return sb.toString();
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    protected abstract HttpMessage createInvalidMessage();

    private static int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    private static String readLine(ByteBuf buffer, int maxLineLength) {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                nextByte = buffer.readByte();
                if (nextByte != 10) continue;
                return sb.toString();
            }
            if (nextByte == 10) {
                return sb.toString();
            }
            if (lineLength >= maxLineLength) {
                throw new TooLongFrameException("An HTTP line is larger than " + maxLineLength + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
    }

    private static String[] splitInitialLine(String sb) {
        int aStart = HttpObjectDecoder.findNonWhitespace(sb, 0);
        int aEnd = HttpObjectDecoder.findWhitespace(sb, aStart);
        int bStart = HttpObjectDecoder.findNonWhitespace(sb, aEnd);
        int bEnd = HttpObjectDecoder.findWhitespace(sb, bStart);
        int cStart = HttpObjectDecoder.findNonWhitespace(sb, bEnd);
        int cEnd = HttpObjectDecoder.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), cStart < cEnd ? sb.substring(cStart, cEnd) : ""};
    }

    private static String[] splitHeader(String sb) {
        int valueStart;
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpObjectDecoder.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        if ((valueStart = HttpObjectDecoder.findNonWhitespace(sb, colonEnd)) == length) {
            return new String[]{sb.substring(nameStart, nameEnd), ""};
        }
        int valueEnd = HttpObjectDecoder.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.substring(valueStart, valueEnd)};
    }

    private static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS,
        READ_FIXED_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT_AS_CHUNKS,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNKED_CONTENT_AS_CHUNKS,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE;

    }
}

