/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.spectra.centroidprofiledetection;

import io.github.msdk.datamodel.MsSpectrum;
import io.github.msdk.datamodel.MsSpectrumType;
import javax.annotation.Nonnull;

public class SpectrumTypeDetectionAlgorithm {
    public static MsSpectrumType detectSpectrumType(@Nonnull MsSpectrum msSpectrum) {
        double[] mzValues = msSpectrum.getMzValues();
        float[] intensityValues = msSpectrum.getIntensityValues();
        Integer size = msSpectrum.getNumberOfDataPoints();
        return SpectrumTypeDetectionAlgorithm.detectSpectrumType(mzValues, intensityValues, size);
    }

    @Nonnull
    public static MsSpectrumType detectSpectrumType(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        int rightIndex;
        int leftIndex;
        if (size < 5) {
            return MsSpectrumType.CENTROIDED;
        }
        int basePeakIndex = 0;
        boolean hasZeroDataPoint = false;
        double scanMzSpan = mzValues[size - 1] - mzValues[0];
        for (int i = 0; i < size; ++i) {
            if (intensityValues[i] > intensityValues[basePeakIndex]) {
                basePeakIndex = i;
            }
            if ((double)intensityValues[i] != 0.0) continue;
            hasZeroDataPoint = true;
        }
        double halfIntensity = (double)intensityValues[basePeakIndex] / 2.0;
        for (leftIndex = basePeakIndex; leftIndex > 0 && (double)intensityValues[leftIndex - 1] > halfIntensity; --leftIndex) {
        }
        for (rightIndex = basePeakIndex; rightIndex < size - 1 && (double)intensityValues[rightIndex + 1] > halfIntensity; ++rightIndex) {
        }
        double mainPeakMzSpan = mzValues[rightIndex] - mzValues[leftIndex];
        int mainPeakDataPointCount = rightIndex - leftIndex + 1;
        if (mainPeakDataPointCount < 3 || mainPeakMzSpan > scanMzSpan / 1000.0) {
            return MsSpectrumType.CENTROIDED;
        }
        if (hasZeroDataPoint) {
            return MsSpectrumType.PROFILE;
        }
        return MsSpectrumType.THRESHOLDED;
    }
}

