/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.powervs.v1.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RegionFluent<A extends RegionFluent<A>>
extends BaseFluent<A> {
    private String cOSRegion;
    private String description;
    private List<String> sysTypes = new ArrayList<String>();
    private String vPCRegion;
    private List<String> vPCZones = new ArrayList<String>();
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RegionFluent() {
    }

    public RegionFluent(Region instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Region instance) {
        Region region = instance = instance != null ? instance : new Region();
        if (instance != null) {
            this.withCOSRegion(instance.getCOSRegion());
            this.withDescription(instance.getDescription());
            this.withSysTypes(instance.getSysTypes());
            this.withVPCRegion(instance.getVPCRegion());
            this.withVPCZones(instance.getVPCZones());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCOSRegion() {
        return this.cOSRegion;
    }

    public A withCOSRegion(String cOSRegion) {
        this.cOSRegion = cOSRegion;
        return (A)((Object)this);
    }

    public boolean hasCOSRegion() {
        return this.cOSRegion != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public A addToSysTypes(int index, String item) {
        if (this.sysTypes == null) {
            this.sysTypes = new ArrayList<String>();
        }
        this.sysTypes.add(index, item);
        return (A)((Object)this);
    }

    public A setToSysTypes(int index, String item) {
        if (this.sysTypes == null) {
            this.sysTypes = new ArrayList<String>();
        }
        this.sysTypes.set(index, item);
        return (A)((Object)this);
    }

    public A addToSysTypes(String ... items) {
        if (this.sysTypes == null) {
            this.sysTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.sysTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSysTypes(Collection<String> items) {
        if (this.sysTypes == null) {
            this.sysTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.sysTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSysTypes(String ... items) {
        if (this.sysTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sysTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSysTypes(Collection<String> items) {
        if (this.sysTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sysTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSysTypes() {
        return this.sysTypes;
    }

    public String getSysType(int index) {
        return this.sysTypes.get(index);
    }

    public String getFirstSysType() {
        return this.sysTypes.get(0);
    }

    public String getLastSysType() {
        return this.sysTypes.get(this.sysTypes.size() - 1);
    }

    public String getMatchingSysType(Predicate<String> predicate) {
        for (String item : this.sysTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSysType(Predicate<String> predicate) {
        for (String item : this.sysTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSysTypes(List<String> sysTypes) {
        if (sysTypes != null) {
            this.sysTypes = new ArrayList<String>();
            for (String item : sysTypes) {
                this.addToSysTypes(item);
            }
        } else {
            this.sysTypes = null;
        }
        return (A)((Object)this);
    }

    public A withSysTypes(String ... sysTypes) {
        if (this.sysTypes != null) {
            this.sysTypes.clear();
            this._visitables.remove((Object)"sysTypes");
        }
        if (sysTypes != null) {
            for (String item : sysTypes) {
                this.addToSysTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSysTypes() {
        return this.sysTypes != null && !this.sysTypes.isEmpty();
    }

    public String getVPCRegion() {
        return this.vPCRegion;
    }

    public A withVPCRegion(String vPCRegion) {
        this.vPCRegion = vPCRegion;
        return (A)((Object)this);
    }

    public boolean hasVPCRegion() {
        return this.vPCRegion != null;
    }

    public A addToVPCZones(int index, String item) {
        if (this.vPCZones == null) {
            this.vPCZones = new ArrayList<String>();
        }
        this.vPCZones.add(index, item);
        return (A)((Object)this);
    }

    public A setToVPCZones(int index, String item) {
        if (this.vPCZones == null) {
            this.vPCZones = new ArrayList<String>();
        }
        this.vPCZones.set(index, item);
        return (A)((Object)this);
    }

    public A addToVPCZones(String ... items) {
        if (this.vPCZones == null) {
            this.vPCZones = new ArrayList<String>();
        }
        for (String item : items) {
            this.vPCZones.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVPCZones(Collection<String> items) {
        if (this.vPCZones == null) {
            this.vPCZones = new ArrayList<String>();
        }
        for (String item : items) {
            this.vPCZones.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVPCZones(String ... items) {
        if (this.vPCZones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.vPCZones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVPCZones(Collection<String> items) {
        if (this.vPCZones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.vPCZones.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVPCZones() {
        return this.vPCZones;
    }

    public String getVPCZone(int index) {
        return this.vPCZones.get(index);
    }

    public String getFirstVPCZone() {
        return this.vPCZones.get(0);
    }

    public String getLastVPCZone() {
        return this.vPCZones.get(this.vPCZones.size() - 1);
    }

    public String getMatchingVPCZone(Predicate<String> predicate) {
        for (String item : this.vPCZones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVPCZone(Predicate<String> predicate) {
        for (String item : this.vPCZones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVPCZones(List<String> vPCZones) {
        if (vPCZones != null) {
            this.vPCZones = new ArrayList<String>();
            for (String item : vPCZones) {
                this.addToVPCZones(item);
            }
        } else {
            this.vPCZones = null;
        }
        return (A)((Object)this);
    }

    public A withVPCZones(String ... vPCZones) {
        if (this.vPCZones != null) {
            this.vPCZones.clear();
            this._visitables.remove((Object)"vPCZones");
        }
        if (vPCZones != null) {
            for (String item : vPCZones) {
                this.addToVPCZones(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVPCZones() {
        return this.vPCZones != null && !this.vPCZones.isEmpty();
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)((Object)this);
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)((Object)this);
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)((Object)this);
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove((Object)"zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegionFluent that = (RegionFluent)((Object)o);
        if (!Objects.equals(this.cOSRegion, that.cOSRegion)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.sysTypes, that.sysTypes)) {
            return false;
        }
        if (!Objects.equals(this.vPCRegion, that.vPCRegion)) {
            return false;
        }
        if (!Objects.equals(this.vPCZones, that.vPCZones)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cOSRegion, this.description, this.sysTypes, this.vPCRegion, this.vPCZones, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cOSRegion != null) {
            sb.append("cOSRegion:");
            sb.append(this.cOSRegion + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.sysTypes != null && !this.sysTypes.isEmpty()) {
            sb.append("sysTypes:");
            sb.append(String.valueOf(this.sysTypes) + ",");
        }
        if (this.vPCRegion != null) {
            sb.append("vPCRegion:");
            sb.append(this.vPCRegion + ",");
        }
        if (this.vPCZones != null && !this.vPCZones.isEmpty()) {
            sb.append("vPCZones:");
            sb.append(String.valueOf(this.vPCZones) + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(String.valueOf(this.zones) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

