/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.element.svg;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.impl.CustomAttribute;
import java.util.Locale;
import java.util.Optional;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseSettings;
import org.vaadin.firitin.util.VStyle;

public class SvgElement
extends Element {
    public static SvgElement emptySvgRoot() {
        SvgElement svg = new SvgElement("svg");
        svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        svg.setAttribute("version", "1.1");
        return svg;
    }

    public SvgElement(String tag) {
        super(tag);
    }

    public <T extends SvgElement> T id(String id) {
        this.setAttribute("id", id);
        return (T)((Object)this);
    }

    public <T extends SvgElement> T viewBox(double minX, double minY, double width, double height) {
        this.setAttribute("viewBox", "%s %s %s %s".formatted(minX, minY, width, height));
        return (T)((Object)this);
    }

    public <T extends SvgElement> T width(double width) {
        this.setAttribute("width", String.valueOf(width));
        return (T)((Object)this);
    }

    public <T extends SvgElement> T width(String width) {
        this.setAttribute("width", width);
        return (T)((Object)this);
    }

    public <T extends SvgElement> T height(double height) {
        this.setAttribute("height", String.valueOf(height));
        return (T)((Object)this);
    }

    public <T extends SvgElement> T height(String height) {
        this.setAttribute("height", height);
        return (T)((Object)this);
    }

    public <T extends SvgElement> T size(double width, double height) {
        this.width(width);
        this.height(height);
        return (T)((Object)this);
    }

    public <T extends SvgElement> T size(String width, String height) {
        this.width(width);
        this.height(height);
        return (T)((Object)this);
    }

    public <T extends SvgElement> T preserveAspectRatio(PreserveAspectRatio ratio) {
        this.setAttribute("preserveAspectRatio", ratio.toString());
        return (T)((Object)this);
    }

    public <T extends SvgElement> T preserveAspectRatio(String ratio) {
        this.setAttribute("preserveAspectRatio", ratio);
        return (T)((Object)this);
    }

    public SvgElement(int minX, int minY, int width, int height) {
        super("svg");
        this.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        this.setAttribute("version", "1.1");
        this.setAttribute("viewBox", "%s %s %s %s".formatted(minX, minY, width, height));
    }

    public Element setAttribute(String attribute, String value) {
        String lowerCasedAttribute = this.validateAttribute(attribute, value);
        Optional customAttribute = CustomAttribute.get((String)lowerCasedAttribute);
        if (customAttribute.isPresent()) {
            ((CustomAttribute)customAttribute.get()).setAttribute((Element)this, value);
        } else {
            this.getStateProvider().setAttribute(this.getNode(), attribute, value);
        }
        return this;
    }

    private String validateAttribute(String attribute, Object value) {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        String lowerCaseAttribute = attribute.toLowerCase(Locale.ENGLISH);
        if (!ElementUtil.isValidAttributeName((String)lowerCaseAttribute)) {
            throw new IllegalArgumentException(String.format("Attribute \"%s\" is not a valid attribute name", lowerCaseAttribute));
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return lowerCaseAttribute;
    }

    public String getOuterHTML() {
        Document document = new Document("http://www.w3.org/2000/svg", "");
        document.parser().settings(ParseSettings.preserveCase);
        return ElementUtil.toJsoup((Document)document, (Element)this).outerHtml();
    }

    public VStyle getStyle() {
        return VStyle.wrap(super.getStyle());
    }

    public static enum PreserveAspectRatio {
        NONE("none"),
        XMID_YMID_MEET("xMidYMid meet"),
        XMID_YMID_SLICE("xMidYMid slice"),
        XMIN_YMIN_MEET("xMinYMin meet"),
        XMIN_YMIN_SLICE("xMinYMin slice"),
        XMID_YMIN_MEET("xMidYMin meet"),
        XMAX_YMIN_MEET("xMaxYMin meet"),
        XMIN_YMID_MEET("xMinYMid meet"),
        XMAX_YMID_MEET("xMaxYMid meet"),
        XMIN_YMAX_MEET("xMinYMax meet"),
        XMID_YMAX_MEET("xMidYMax meet"),
        XMAX_YMAX_MEET("xMaxYMax meet");

        private final String value;

        private PreserveAspectRatio(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

