/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.template.annotations.ImageMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IFieldsMetadataClassSerializer;
import fr.opensagres.xdocreport.template.formatter.IPropertyDescriptorFilter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldsMetadataClassSerializer
implements IFieldsMetadataClassSerializer {
    private static Class IIMAGEPROVIDER_CLASS = null;
    private final String id;
    private final String description;
    private final List<String> excludedPackages;
    private IPropertyDescriptorFilter filter = new AllowAllPropertyDescriptorFilter();

    public AbstractFieldsMetadataClassSerializer(String id, String description) {
        this.id = id;
        this.description = description;
        this.excludedPackages = new ArrayList<String>();
        this.excludedPackages.add("java.");
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFilter(IPropertyDescriptorFilter filter) {
        this.filter = filter;
    }

    @Override
    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz) throws XDocReportException {
        this.load(fieldsMetadata, key, clazz, false);
    }

    @Override
    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, boolean listType) throws XDocReportException {
        try {
            ArrayList<PropertyDescriptor> path = new ArrayList<PropertyDescriptor>();
            this.process(fieldsMetadata, key, clazz, path, listType);
        }
        catch (Exception e) {
            throw new XDocReportException((Throwable)e);
        }
    }

    private void process(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, List<PropertyDescriptor> path, boolean isList) throws IntrospectionException {
        PropertyDescriptor[] descs;
        BeanInfo infos = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : descs = infos.getPropertyDescriptors()) {
            if (this.isTransient(propertyDescriptor, clazz) || !this.haveGetterMethod(propertyDescriptor)) continue;
            Method method = propertyDescriptor.getReadMethod();
            Class<?> returnTypeClass = method.getReturnType();
            boolean wasVisited = false;
            for (PropertyDescriptor item : path) {
                if (!item.equals(propertyDescriptor)) continue;
                wasVisited = true;
                break;
            }
            if (wasVisited) continue;
            if (this.filter.test(propertyDescriptor)) {
                return;
            }
            if (Iterable.class.isAssignableFrom(returnTypeClass)) {
                ParameterizedType parameterizedType;
                Type[] types;
                Type collectionType = method.getGenericReturnType();
                if (collectionType == null || !(collectionType instanceof ParameterizedType) || (types = (parameterizedType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
                Class itemClazz = null;
                if (types[0] instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)types[0];
                    if (wildcardType.getLowerBounds().length != 0) {
                        itemClazz = (Class)wildcardType.getLowerBounds()[0];
                    } else if (wildcardType.getUpperBounds().length != 0) {
                        itemClazz = (Class)wildcardType.getUpperBounds()[0];
                    }
                } else {
                    itemClazz = (Class)types[0];
                }
                if (itemClazz == null) continue;
                if (this.isImageField(itemClazz)) {
                    this.addField(key, fieldsMetadata, path, propertyDescriptor, true, true);
                    continue;
                }
                if (this.isTextField(itemClazz)) {
                    this.addField(key, fieldsMetadata, path, propertyDescriptor, true, false);
                    continue;
                }
                path.add(propertyDescriptor);
                this.process(fieldsMetadata, key, itemClazz, path, true);
                path.remove(propertyDescriptor);
                continue;
            }
            if (this.isImageField(returnTypeClass)) {
                this.addField(key, fieldsMetadata, path, propertyDescriptor, isList, true);
                continue;
            }
            if (this.isTextField(returnTypeClass)) {
                this.addField(key, fieldsMetadata, path, propertyDescriptor, isList, false);
                continue;
            }
            path.add(propertyDescriptor);
            this.process(fieldsMetadata, key, returnTypeClass, path, isList);
            path.remove(propertyDescriptor);
        }
    }

    private boolean isTextField(Class<?> returnTypeClass) {
        return String.class.isAssignableFrom(returnTypeClass) || this.isClassToExclude(returnTypeClass);
    }

    private boolean isImageField(Class<?> returnTypeClass) {
        return InputStream.class.isAssignableFrom(returnTypeClass) || byte[].class.isAssignableFrom(returnTypeClass) || File.class.isAssignableFrom(returnTypeClass) || IIMAGEPROVIDER_CLASS != null && IIMAGEPROVIDER_CLASS.isAssignableFrom(returnTypeClass);
    }

    private void addField(String key, FieldsMetadata fieldsMetadata, List<PropertyDescriptor> path, PropertyDescriptor currentField, Boolean isList, boolean isImage) {
        String fieldName = this.createFieldName(key, path, currentField);
        for (FieldMetadata fieldMetadata : fieldsMetadata.getFields()) {
            if (!fieldMetadata.getFieldName().equals(fieldName)) continue;
            return;
        }
        Method method = currentField.getReadMethod();
        fr.opensagres.xdocreport.template.annotations.FieldMetadata fMetadata = method.getAnnotation(fr.opensagres.xdocreport.template.annotations.FieldMetadata.class);
        if (fMetadata != null) {
            ImageMetadata[] images = fMetadata.images();
            if (images.length < 1) {
                this.addFieldAndUpdateWithAnnotation(fieldsMetadata, isList, fieldName, null, fMetadata);
            } else {
                for (int i = 0; i < images.length; ++i) {
                    this.addFieldAndUpdateWithAnnotation(fieldsMetadata, isList, fieldName, images[i], fMetadata);
                }
            }
        } else {
            String imageName = isImage ? fieldName : null;
            fieldsMetadata.addField(fieldName, isList, imageName, null, null);
        }
    }

    private String createFieldName(String key, List<PropertyDescriptor> path, PropertyDescriptor currentField) {
        StringBuilder fieldName = new StringBuilder(key);
        for (PropertyDescriptor fieldFromPath : path) {
            fieldName.append(this.getFieldName("", fieldFromPath.getName()));
        }
        fieldName.append(this.getFieldName("", currentField.getName()));
        return fieldName.toString();
    }

    private void addFieldAndUpdateWithAnnotation(FieldsMetadata fieldsMetadata, Boolean isList, String fieldName, ImageMetadata imageData, fr.opensagres.xdocreport.template.annotations.FieldMetadata fMetadata) {
        String imageName = null;
        if (imageData != null) {
            imageName = imageData.name();
        }
        FieldMetadata newField = fieldsMetadata.addField(fieldName.toString(), isList, imageName, fMetadata.syntaxKind(), fMetadata.syntaxWithDirective());
        newField.setDescription(fMetadata.description());
        if (imageData != null) {
            newField.setBehaviour(imageData.behaviour());
        }
    }

    private boolean isTransient(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        try {
            if (clazz != null) {
                Field field = clazz.getDeclaredField(propertyDescriptor.getName());
                return Modifier.isTransient(field.getModifiers());
            }
            return false;
        }
        catch (SecurityException e) {
            return true;
        }
        catch (NoSuchFieldException e) {
            Class<?>[] interfaces;
            if (this.isTransient(propertyDescriptor, clazz.getSuperclass())) {
                return true;
            }
            for (Class<?> _interfase : interfaces = clazz.getInterfaces()) {
                if (!this.isTransient(propertyDescriptor, _interfase)) continue;
                return true;
            }
            return false;
        }
    }

    private boolean haveGetterMethod(PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getReadMethod();
        return this.isGetterMethod(method);
    }

    private boolean isClassToExclude(Class<?> clazz) {
        if (clazz != null && clazz.getPackage() != null) {
            String packageName = clazz.getPackage().getName();
            for (String excludePackageName : this.excludedPackages) {
                if (!packageName.startsWith(excludePackageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGetterMethod(Method method) {
        if (method == null) {
            return false;
        }
        String name = method.getName();
        return !name.equals("getClass") && (name.startsWith("get") || name.startsWith("is"));
    }

    protected abstract String getFieldName(String var1, String var2);

    static {
        try {
            IIMAGEPROVIDER_CLASS = Class.forName("fr.opensagres.xdocreport.document.images.IImageProvider");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    static class AllowAllPropertyDescriptorFilter
    implements IPropertyDescriptorFilter {
        AllowAllPropertyDescriptorFilter() {
        }

        public boolean test(PropertyDescriptor descriptor) {
            return false;
        }
    }
}

