package fr.onema.sispea.struts.user.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.user.UserDto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

/**
 * This class is modeling a user form.
 *
 * @author CS
 */
public class UserFormBean extends UserDto {

    /**
     * id of no form.
     */
    protected static final int noFormId = 0;

    /**
     * id of user form.
     */
    protected static final int userFormId = 1;

    /**
     * id of user territory form.
     */
    protected static final int territoryFormId = 2;

    /**
     * id of user date form.
     */
    protected static final int dateFormId = 3;

    /**
     * id of user creation form.
     */
    protected static final int creationFormId = 4;

    /**
     * id of user ids form.
     */
    protected static final int idsFormId = 5;

    private static final long serialVersionUID = 1L;

    /**
     * default values
     */
    private static final Integer DEFAULT_VALIDITY_END_DATE_YEAR = 2009;

    private static final Integer DEFAULT_DAYS_NUMBER = 31;

    private static final Integer DEFAULT_MONTH_NUMBER = 12;

    private static final Integer DEFAULT_YEAR_NUMBER = 20;

    /**
     * The form to edit or being edited
     */
    protected int form = noFormId;

    /**
     * The new password
     */
    protected String passWordNew = null;

    /**
     * The password confirmation
     */
    protected String passWordConfirm = null;

    /**
     * Should delete the user ?
     */
    protected Boolean toDelete = null;

    /**
     * user validity end date day
     */
    protected Integer validityEndDateDay = 1;

    /**
     * user validity end date month
     */
    protected Integer validityEndDateMonth = 1;

    /**
     * user validity end date year
     */
    protected Integer validityEndDateYear = DEFAULT_VALIDITY_END_DATE_YEAR;

    public UserFormBean() {
    }

    public UserFormBean(UserDto pUser) {
        super(pUser);
    }

    @Override
    public void trim() {
        if (getEmail() != null) {
            setEmail(getEmail().trim());
        }
        if (getFirstName() != null) {
            setFirstName(getFirstName().trim());
        }
        if (getLogin() != null) {
            setLogin(getLogin().trim());
        }
        if (getName() != null) {
            setName(getName().trim());
        }
        if (getOldLogin() != null) {
            setOldLogin(getOldLogin().trim());
        }
        if (getOldPassWord() != null) {
            setOldPassWord(getOldPassWord().trim());
        }
        if (getPassWord() != null) {
            setPassWord(getPassWord().trim());
        }
        if (getPassWordConfirm() != null) {
            setPassWordConfirm(getPassWordConfirm().trim());
        }
        if (getPassWordNew() != null) {
            setPassWordNew(getPassWordNew().trim());
        }
    }

    /**
     * @return true if login has changed, false else
     */
    public Boolean loginChanged() {

        //init
        Boolean lRes = false;
        String lCurrentLogin = getLogin();
        String lOldLogin = getOldLogin();

        // check old login
        // old login not null -> compare with current login
        if ((lOldLogin != null) && (lOldLogin.length() > 0) && (!lOldLogin.equals(lCurrentLogin))) {
            lRes = true;
        }

        // result
        return lRes;
    }

    /**
     * @return true if email has changed, false else
     */
    public Boolean eMailChanged() {

        //init
        Boolean lRes = false;
        String lCurrentEmail = getEmail();
        String lOldEmail = getOldEmail();

        // check old Email
        // old Email not null -> compare with current Email
        if ((lOldEmail != null) && (lOldEmail.length() > 0) && (!lOldEmail.equals(lCurrentEmail))) {
            lRes = true;
        }

        // result
        return lRes;
    }

    /**
     * @return available days list
     */
    public List<Integer> getDateDays() {
        //init list
        ArrayList<Integer> lRes = new ArrayList<>();
        // loop
        for (Integer i = 1; i <= DEFAULT_DAYS_NUMBER; i++) {
            lRes.add(i);
        }
        // sort
        Collections.sort(lRes);
        // result
        return lRes;
    }

    /**
     * @return available month list
     */
    public List<Integer> getDateMonth() {
        //init list
        ArrayList<Integer> lRes = new ArrayList<>();
        // loop
        for (Integer i = 1; i <= DEFAULT_MONTH_NUMBER; i++) {
            lRes.add(i);
        }
        // sort
        Collections.sort(lRes);
        // result
        return lRes;
    }

    /**
     * @return available year list
     */
    public List<Integer> getDateYears() {
        //init list
        ArrayList<Integer> lRes = new ArrayList<>();
        // loop
        for (Integer i = DEFAULT_VALIDITY_END_DATE_YEAR; i <= DEFAULT_VALIDITY_END_DATE_YEAR + DEFAULT_YEAR_NUMBER; i++) {
            lRes.add(i);
        }
        // sort
        Collections.sort(lRes);
        // result
        return lRes;
    }

    public String getPassWordNew() {
        return passWordNew;
    }

    public void setPassWordNew(String pPassWordNew) {
        passWordNew = pPassWordNew;
    }

    public String getPassWordConfirm() {
        return passWordConfirm;
    }

    public void setPassWordConfirm(String pPassWordConfirm) {
        passWordConfirm = pPassWordConfirm;
    }

    public Boolean getToDelete() {
        return toDelete;
    }

    public void setToDelete(Boolean pToDelete) {
        toDelete = pToDelete;
    }

    public int getForm() {
        return form;
    }

    public void setForm(int pForm) {
        form = pForm;
    }

    public int getNoFormId() {
        return noFormId;
    }

    public int getUserFormId() {
        return userFormId;
    }

    public int getIdsFormId() {
        return idsFormId;
    }

    public int getTerritoryFormId() {
        return territoryFormId;
    }

    public int getDateFormId() {
        return dateFormId;
    }

    public int getCreationFormId() {
        return creationFormId;
    }

    public Integer getValidityEndDateDay() {

        // init result
        Integer lRes = validityEndDateDay;
        if (getValidityEndDate() != null) {
            lRes = getValidityEndDate().get(Calendar.DAY_OF_MONTH);
        }

        // result
        return lRes;
    }

    public void setValidityEndDateDay(Integer pValidityEndDateDay) {
        validityEndDateDay = pValidityEndDateDay;
    }

    public Integer getValidityEndDateMonth() {

        // init result
        Integer lRes = validityEndDateMonth;
        if (getValidityEndDate() != null) {
            // get month idx
            lRes = getValidityEndDate().get(Calendar.MONTH);
            // add one for display
            lRes = lRes + 1;
        }

        // result
        return lRes;
    }

    public void setValidityEndDateMonth(Integer pValidityEndDateMonth) {
        validityEndDateMonth = pValidityEndDateMonth;
    }

    public Integer getValidityEndDateYear() {
        // init result
        Integer lRes = validityEndDateYear;
        if (getValidityEndDate() != null) {
            lRes = getValidityEndDate().get(Calendar.YEAR);
        }

        // result
        return lRes;
    }

    public void setValidityEndDateYear(Integer pValidityEndDateYear) {
        validityEndDateYear = pValidityEndDateYear;
    }

}
