package fr.onema.sispea.struts.user.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.TerritoryDto;

import java.io.Serializable;
import java.util.Comparator;

public class SelectionComparator implements Comparator<Object>, Serializable {

    private static final long serialVersionUID = 1L;

    private int selectionType;

    private Integer criterion;

    private Integer direction;

    public SelectionComparator() {
    }


    public SelectionComparator(int pSelectionType, Integer pCriterion, Integer pDirection) {
        selectionType = pSelectionType;
        criterion = pCriterion;
        direction = pDirection;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        TerritoryDto t1 = (TerritoryDto) arg0;
        TerritoryDto t2 = (TerritoryDto) arg1;

        if (selectionType == 1) {
            // SINGLE SELECTIONS
            if (criterion != null) {
                if (criterion == 1) {
                    // BY NAME
                    if (direction == 0)
                        return t1.getName().compareTo(t2.getName());
                    else
                        return t2.getName().compareTo(t1.getName());
                } else {
                    // BY TYPE (if name is different)
                    if (t1.getType().equals(t2.getType()))
                        return t1.getName().compareTo(t2.getName());
                    else if (direction == 0)
                        return t1.getType().compareTo(t2.getType());
                    else
                        return t2.getType().compareTo(t1.getType());
                }
            } else {
                // no criterion: shouldn't be possible but ok... sort by name then
                return t1.getName().compareTo(t2.getName());
            }
        } else {
            // MULTIPLE SELECTIONS
            if (criterion != null) {
                if (criterion == 1) {
                    // BY NAME
                    if (direction == 0)
                        return t1.getName().compareTo(t2.getName());
                    else
                        return t2.getName().compareTo(t1.getName());
                } else {
                    // BY TERRITORY
                    OrganismDto lTerr1 = null;
                    OrganismDto lTerr2 = null;
                    if (t1.getOrganisms().size() > 0) {
                        lTerr1 = t1.getOrganisms().iterator().next();
                    }
                    if (t2.getOrganisms().size() > 0) {
                        lTerr2 = t2.getOrganisms().iterator().next();
                    }

                    if (lTerr1 != null && lTerr2 != null) {
                        if (direction == 0)
                            return lTerr1.getName().compareTo(lTerr2.getName());
                        else
                            return lTerr2.getName().compareTo(lTerr1.getName());
                    } else if (lTerr1 == null && lTerr2 == null) {
                        // sort by name otherwise
                        return t1.getName().compareTo(t2.getName());
                    } else if (lTerr1 == null) {
                        if (direction == 0)
                            return 1;
                        else
                            return -1;
                    } else {
                        if (direction == 0)
                            return -1;
                        else
                            return 1;
                    }
                }
            } else {
                // no criterion: shouldn't be possible but ok... sort by name then
                return t1.getName().compareTo(t2.getName());
            }
        }
    }

    public Integer getCriterion() {
        return criterion;
    }

    public void setCriterion(Integer pCriterion) {
        criterion = pCriterion;
    }

    public Integer getDirection() {
        return direction;
    }

    public void setDirection(Integer pDirection) {
        direction = pDirection;
    }


    public int getSelectionType() {
        return selectionType;
    }


    public void setSelectionType(int pSelectionType) {
        selectionType = pSelectionType;
    }

}
