package fr.onema.sispea.struts.user.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.search.MandateOrderByFieldPossibility;
import fr.onema.sispea.service.search.OrderByFieldType;

import java.io.Serializable;

/**
 * This class holds the paging information for the different mandates.
 *
 * @author CS
 */
public class MandatePagingBean implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The paging information.
     */
    protected PagingDto paging = new PagingDto();

    /**
     * The requested table column sorting criterion
     */
    protected MandateOrderByFieldPossibility sortCriterion = null;

    /**
     * The requested table column sorting direction
     */
    protected OrderByFieldType sortDirection = OrderByFieldType.ASC;

    public MandatePagingBean(MandateOrderByFieldPossibility pSortCriterion) {

        paging = new PagingDto();
        paging.setPageSize(10);

        sortCriterion = pSortCriterion;
        sortDirection = OrderByFieldType.ASC;
    }

    public PagingDto getPaging() {
        return paging;
    }

    public void setPaging(PagingDto pPaging) {
        paging = pPaging;
    }

    /**
     * Toggle sort direction: set to desc if asc, and set to asc if desc
     *
     * @return
     */
    public Integer toggleSortDirection() {
        Integer sortDirectionId = OrderByFieldType.ASC.getId();
        if (sortDirection == OrderByFieldType.ASC) {
            sortDirectionId = OrderByFieldType.DESC.getId();
        }
        return sortDirectionId;
    }

    public int getSortCriterionId() {
        return sortCriterion.getId();
    }

    public void setSortCriterionId(int pSortCriterionId) {
        sortCriterion = MandateOrderByFieldPossibility.parseFromDbId(pSortCriterionId);
    }

    public MandateOrderByFieldPossibility getSortCriterion() {
        return sortCriterion;
    }

    public void setSortCriterionId(String pSortCriterionId) {
        setSortCriterionId(Integer.valueOf(pSortCriterionId));
    }

    public OrderByFieldType getSortDirection() {
        return sortDirection;
    }

    public void setSortDirection(OrderByFieldType pSortDirection) {
        sortDirection = pSortDirection;
    }

    public int getSortDirectionId() {
        return sortDirection.getId();
    }

    public void setSortDirectionId(int pSortDirectionId) {
        sortDirection = OrderByFieldType.parseFromDbId(pSortDirectionId);
    }

}
